--  This module will transliterate Khakas language text per WT:KJH TR.
-- Language code: kjh

local export = {}

local tt = {
	["А"]='A', ["а"]='a', ["Б"]='B', ["б"]='b', ["В"]='V', ["в"]='v', ["Г"]='G', ["г"]='g',
	["Ғ"]='Ğ', ["ғ"]='ğ', ["Д"]='D', ["д"]='d', ["Е"]='E', ["е"]='e', ["Ё"]='Yo', ["ё"]='yo',
	["Ж"]='J', ["ж"]='j', ["З"]='Z', ["з"]='z', ["И"]='İ', ["и"]='i', ["Й"]='Y', ["й"]='y',
	["І"]='Í', ["і"]='í', ["К"]='K', ["к"]='k', ["Л"]='L', ["л"]='l', ["М"]='M', ["м"]='m',
	["Н"]='N', ["н"]='n', ["Ң"]='Ñ', ["ң"]='ñ', ["О"]='O', ["о"]='o', ["Ö"]='Ö', ["ö"]='ö',
	["П"]='P', ["п"]='p', ["Р"]='R', ["р"]='r', ["С"]='S', ["с"]='s', ["Т"]='T', ["т"]='t',
	["У"]='U', ["у"]='u', ["Ӱ"]='Ü', ["ӱ"]='ü', ["Ф"]='F', ["ф"]='f', ["Х"]='X', ["х"]='x',
	["Ц"]='Ts', ["ц"]='ts', ["Ч"]='Ç', ["ч"]='ç', ["Ӌ"]='C', ["ӌ"]='c', ["Ш"]='Ş', ["ш"]='ş',
	["Щ"]='Şç', ["щ"]='şç', ['Ъ']='ʺ', ['ъ']='ʺ', ["Ы"]='I', ["ы"]='ı', ["Ь"]="’", ["ь"]="’",
	["Э"]='E', ["э"]='e', ["Ю"]='Yu', ["ю"]='yu', ["Я"]='Ya', ["я"]='ya',
};

function export.tr(text)
	return (mw.ustring.gsub(text, '.', tt))
end

return export