###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

######################################################################
# propSemRoles.rb
# 
# Should be done on the .argtrees or later because it needs -argX info.
# It propagates only "a0", "a1", etc. but not "m". The "m" will be done
# as part of the calcHdwdTree-srl.rb
#
# Here are the rules:
#
#S -> NP VP
#     a0  id
#
#VP -> VB-argX X     Exception is when X=VPxxx
#              a1
#
#VB-argX -> VB-argX-argY Y...
#                        a2
#
#VB-argX -> VB-argX-argY-argZ  Z...
#                              a3
#
# TO RUN: cat genmodel/<file>.gaptrees | ruby scripts/propSemRoles.rb [-v]
#
# OPTIONS:
#  -v verbose mode
#
######################################################################

require "scripts/umnlp.rb"

##### parse options
require 'optparse'

$options = {}
$options[:verbose] = false

OptionParser.new do |opts|
  opts.banner = "Usage: ruby propSemRoles.rb [options]"
  
  opts.on("-v", "--verbose", "turns on extra stderr output") do |v|
    $options[:verbose] = v
  end
  end.parse!
  
  $label="\w+\!semdelim\!"
  $id = "id!semdelim!"
  $idm = "idm!semdelim!"
  $a0 = "a0!semdelim!"
  $a1 = "a1!semdelim!"
  $a2 = "a2!semdelim!"
  $a3 = "a3!semdelim!"
  $a4 = "a4!semdelim!"
  #####
  class Tree
    def assignIdToTheRest
      if @children.size > 0
        if @head !~ /\!semdelim\!/
          @head = $id + @head
        end
        @children.each { |c| c.assignIdToTheRest }
      end
    end
    
    def propSemRoles
      if matchCat(@head, 'WHSBAR') 
        doWHSBAR
      elsif matchCat(@head, 'PP') 
        doPP
      elsif matchCat(@head, 'Sprovbg')
        doSprovbg
#      elsif matchCat(@head, 'Sto')
#        doSto
      elsif matchCat(@head, 'S')
        doS
      elsif matchCat(@head, 'V[PB]')
        doVP
      elsif matchCat(@head, 'NP')
        doNP
      end
      @children.each { |c| c.propSemRoles }
    end
    
    def doSto
      if @children.size == 2 && matchCat(@children[0].head, 'NP') && matchCat(@children[1].head, 'VPto')   
        @children[0].head = $a1 + @children[0].head 
        @children[1].head = $id + @children[1].head
      end
    end
    
    def doSprovbg
      if @children.size == 2 && matchCat(@children[0].head, 'VBGvbg') && matchCat(@children[1].head, 'NP')   
        @children[1].head = $a1 + @children[1].head
      end
    end
    
    def doWHSBAR
      if @children.size == 2 && matchCat(@children[0].head, 'WHNP') && matchCat(@children[1].head, 'S')   
        @children[0].head = $a0 + @children[0].head
      end
    end
    
    def doNP
      if @children.size == 2 && matchCat(@children[0].head, 'NP') && matchCat(@children[1].head, 'WHSBAR')   
        @children[0].head = $a0 + @children[0].head
        @children[1].head = $idm + @children[1].head
      end
    end
    
    def doS
      if @children.size == 2 && matchCat(@children[0].head, 'NP') && matchCat(@children[1].head, 'VP')
#        @head = $id + @head
        @children[0].head = $a0 + @children[0].head 
        @children[1].head = $id + @children[1].head
      elsif @children.size == 2 && matchCat(@children[0].head, 'V[PB].*\-arg') # sent. 4: S-br -> VBGvbg-argNP NP Treat this S node like a V[PB] node
        doVP
      else
        $stderr.print $lineNum, " doS ", @head, " --> "
        @children.each { |c| $stderr.print c.head, " " }
        $stderr.print "\n"
      end
    end
    
    def doVP
      if @children.size == 2 && @children[0].head =~ /\-arg/
#        @head = $id + @head
        s = @children[0].head.split("-arg")
        a = "a" + (s.size - 1).to_s
        if ! (a == "a1" && @children[0].head =~ /\-argVP/ )  #exception: don't set a1 for VP -> VP-argVP VP
          # use ida1 for Sproto so that the upward projection won't stop at this node. Treat it as a1 by the way
          prependId = @children[1].head =~ /Sproto$/ ? "id" : ""
          @children[1].head = prependId + a  + "!semdelim!" + @children[1].head
        end
      elsif @children.size == 2 && matchCat(@children[0].head, 'V[PB]') && matchCat(@children[1].head, 'WHSBAR')
        @children[1].head = $a1 + @children[1].head
      else
        $stderr.print $lineNum, " doVP ", @head, " --> "
        @children.each { |c| $stderr.print c.head, " " }
        $stderr.print "\n"
      end
    end
    
    def doPP
      if @children.size == 2 && @children[0].head =~ /\-arg/
        @children[1].head = "a1!semdelim!" + @children[1].head
      else
        $stderr.print $lineNum, " doPP ", @head, " --> "
        @children.each { |c| $stderr.print c.head, " " }
        $stderr.print "\n"
      end
    end
 
    # the category of interest may go right after !pbrdelim! or !semdelim!, hence search delim!S, delim!VP
    # or it could be that the (pbr) label is still at leafs, so search for ^S, ^VP, etc.
    def matchCat(str, cat)
      str =~ /delim!#{cat}/ or str =~ /^#{cat}/
    end
  end
  
  ##########################################
  
  $lineNum = 0
#  File.open("ttt").each_line do |line| 
  while (line = STDIN.gets)
    $lineNum = $lineNum + 1
    t = Tree.new(line)
    t.propSemRoles
    t.assignIdToTheRest
    print t.to_s, "\n"
  end
