// $Id: AlignmentInfo.h 3360 2010-07-17 23:23:09Z hieuhoang1972 $
/***********************************************************************
 Moses - factored phrase-based language decoder
 Copyright (C) 2010 Hieu Hoang
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ***********************************************************************/
#pragma once

#include <list>
#include <ostream>

namespace Moses
{

// Collection of alignment pairs, ordered by source index
class AlignmentInfo
{
	friend std::ostream& operator<<(std::ostream&, const AlignmentInfo&);

protected:
	typedef std::list<std::pair<size_t,size_t> > CollType;
	CollType m_collection;

public:
	typedef CollType::iterator iterator;
	typedef CollType::const_iterator const_iterator;
	const_iterator begin() const { return m_collection.begin(); }
	const_iterator end() const { return m_collection.end(); }

	void AddAlignment(const std::list<std::pair<size_t,size_t> > &alignmentList);
};

};

