#!/bin/bash
#SBATCH --job-name=superglue # create a short name for your job
#SBATCH -p llm
#SBATCH -N 1 # node count
#SBATCH --ntasks-per-node 1 # number of tasks to run per node
#SBATCH --cpus-per-task 10 # cpu-cores per task (>1 if multi-threaded tasks),--cpus-per-task
#SBATCH --gpus-per-node 1 # total gpus for job

OUTPUT_PREFIX=inference_output
RUN=super_glue

python3 bbh_hyperlora_inference_each_task.py \
    --seed 42 \
    --do_eval \
    --do_predict \
    --predict_with_generate \
    --bf16 \
    --dataset_name data/super_glue \
    --hypelora_name_or_path hf_models/hyperlora-t5-large \
    --hyper_model_name_or_path hf_models/t5-large \
    --model_name_or_path hf_models/t5-large \
    --pretrain_checkpoint YOUR_PRETRAIN_CHECKPOINT_FILE \
    --per_device_eval_batch_size 125 \
    --preprocessing_num_workers 16 \
    --n_demonstrations 4 \
    --generation_max_length 512 \
    --max_seq_length 2048 \
    --max_answer_length 512 \
    --val_max_answer_length 512 \
    --input_column src_texts \
    --output_column tgt_texts \
    --temperature 8 \
    --lora_rank 16 \
    --lora_alpha 8 \
    --lora_dropout 0.05 \
    --report_to none \
    --run_name ${OUTPUT_PREFIX}_${RUN} \
    --output_dir output/$OUTPUT_PREFIX/$RUN