export REPO_ROOT=/home/xxx/workspace/LaMP

export CARLA_ROOT=${REPO_ROOT}/carla/CARLA_0.9.10.1
export CARLA_SERVER=${CARLA_ROOT}/CarlaUE4.sh
export LEADERBOARD_ROOT=${REPO_ROOT}/leaderboard
export SCENARIO_RUNNER_ROOT=${REPO_ROOT}/scenario_runner

export PYTHONPATH=${PYTHONPATH}:${REPO_ROOT}/src
export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI
export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI/carla
export PYTHONPATH=${PYTHONPATH}:${CARLA_ROOT}/PythonAPI/carla/dist/carla-0.9.10-py3.7-linux-x86_64.egg
export PYTHONPATH=${PYTHONPATH}:${LEADERBOARD_ROOT}
export PYTHONPATH=${PYTHONPATH}:${SCENARIO_RUNNER_ROOT}

echo $PYTHONPATH

export SCENARIOS=${LEADERBOARD_ROOT}/data/all_towns_traffic_scenarios_public.json
export ROUTES=${LEADERBOARD_ROOT}/data/routes_devtest.xml
export REPETITIONS=1
export DEBUG_CHALLENGE=1
export TEAM_AGENT=${REPO_ROOT}/src/baselines/langprop/expert/expert_agent.py
export TEAM_CONFIG=${REPO_ROOT}/src/baselines/langprop/expert/config/expert.yaml
export CHECKPOINT_ENDPOINT=${LEADERBOARD_ROOT}/results.json
export CHALLENGE_TRACK_CODENAME=SENSORS

python3 ${REPO_ROOT}/src/baselines/langprop/data_collect/data_collector.py \
  --scenarios=${SCENARIOS} \
  --routes=${ROUTES} \
  --repetitions=${REPETITIONS} \
  --track=${CHALLENGE_TRACK_CODENAME} \
  --checkpoint=${CHECKPOINT_ENDPOINT} \
  --agent=${TEAM_AGENT} \
  --agent-config=${TEAM_CONFIG} \
  --debug=${DEBUG_CHALLENGE} \
  --record=${RECORD_PATH} \
  --resume=${RESUME}
