import os
from openai import OpenAI

class Prompter:
    def __init__(self):
        self.client = OpenAI(
            api_key = os.environ.get("OPENAI_API_KEY"),
        )

    def _run_prompt(self, messages, temp=0):
        response = self.client.chat.completions.create(
            messages = messages,
            model="gpt-4-turbo",
            temperature=temp,
            max_tokens=1024,
        )
        return response

    def prompt(self, text):
        initial_content = f"You are a helpful assistant."
        
        prompt = [{"role": "system", "content": initial_content}]

        content = (
            f"Please identify all expressions in the given text that explicitly name or describe a player, coach, or team. This includes direct names, nicknames, and any role-specific references (like positions or accolades) that imply a particular individual or team.\n\n"
            f"Instructions: \n"
            f" 1) Provide a list of expressions (ex. [\"our striker\", \"messi\", \"agent of chaos\", ...])\n"
            f" 2) The expressions can be long, as they also include noun phrases.\n"
            f" 3) Write expressions exactly as they appear in the text. Do not modify the expressions in the text, even if they contain typos. Maintain the original capitalization and spacing, as we will use string matching.\n"
            f" 4) List expressions in the order they appear in the text. If an expression appears multiple times, list it multiple times in the order of appearance.\n"
            f" 5) If the text lacks a suitable expression, provide an empty list.\n\n"
            f"Be sure to follow the following format and write your answer within the list:\n"
            f" [\"Expression 1\", \"Expression 2\", ... ]\n\n"
            f"Text: \n{text}"
        )
        print(content)
        print()
        prompt.extend([{"role": "user", "content": content}])

        response = self._run_prompt(prompt)
        res = response.choices[0].message.content
        print(res)
        return res
        # try:
        #     final_res = eval(res)
        # except:
        #     final_res = []
        # return final_res

if __name__ == "__main__":

    text = '''game analysis'''
    
    prompter = Prompter()
    str_list = prompter.prompt(text)

    try:
        lst = eval(str_list)
    except:
        lst = []
    
    print(type(lst))
    print(lst[0])