/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.negra;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraPennLanguagePack;
import edu.stanford.nlp.trees.international.negra.NegraPennTokenizer;
import edu.stanford.nlp.trees.international.negra.NegraPennTreeNormalizer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class NegraPennTreeReaderFactory
implements TreeReaderFactory,
Serializable {
    private static final long serialVersionUID = 5731352106152470304L;
    private final int nodeCleanup;
    private final TreebankLanguagePack tlp;
    private final boolean treeNormalizerInsertNPinPP;

    public NegraPennTreeReaderFactory() {
        this(2, false, true, new NegraPennLanguagePack());
    }

    public NegraPennTreeReaderFactory(TreebankLanguagePack tlp) {
        this(0, false, false, tlp);
    }

    public NegraPennTreeReaderFactory(int nodeCleanup, boolean treeNormalizerInsertNPinPP, boolean treeNormalizerLeaveGF, TreebankLanguagePack tlp) {
        this.nodeCleanup = nodeCleanup;
        this.treeNormalizerInsertNPinPP = treeNormalizerInsertNPinPP;
        this.tlp = tlp;
    }

    @Override
    public TreeReader newTreeReader(Reader in) {
        NegraPennTreeNormalizer tn = new NegraPennTreeNormalizer(this.tlp, this.nodeCleanup);
        if (this.treeNormalizerInsertNPinPP) {
            tn.setInsertNPinPP(true);
        }
        return new PennTreeReader(in, new LabeledScoredTreeFactory(), tn, new NegraPennTokenizer(in));
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.printf("Usage: java %s tree_file%n", NegraPennTreeReaderFactory.class.getName());
            return;
        }
        NegraPennLanguagePack tlp = new NegraPennLanguagePack();
        NegraPennTreeReaderFactory trf = new NegraPennTreeReaderFactory(2, false, false, tlp);
        try {
            Tree t;
            TreeReader tr = trf.newTreeReader(IOUtils.readerFromString(args[0], tlp.getEncoding()));
            while ((t = tr.readTree()) != null) {
                t.pennPrint();
            }
            tr.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

