/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.trees.Tree;
import java.util.List;

public class ShiftTransition
implements Transition {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isLegal(State state, List<ParserConstraint> constraints) {
        Tree top;
        if (state.finished) {
            return false;
        }
        if (state.tokenPosition >= state.sentence.size()) {
            return false;
        }
        if (state.stack.size() > 0 && (top = state.stack.peek()).label().value().startsWith("@") && top.children().length == 2 && ShiftReduceUtils.getBinarySide(top) == BinaryTransition.Side.RIGHT) {
            return false;
        }
        if (constraints == null || state.stack.size() == 0) {
            return true;
        }
        top = state.stack.peek();
        for (ParserConstraint constraint : constraints) {
            int left;
            if (ShiftReduceUtils.rightIndex(top) != constraint.end - 1 || (left = ShiftReduceUtils.leftIndex(top)) < constraint.start) continue;
            if (left > constraint.start) {
                return false;
            }
            if (ShiftReduceUtils.constraintMatchesTreeTop(top, constraint)) continue;
            return false;
        }
        return true;
    }

    @Override
    public State apply(State state) {
        return this.apply(state, 0.0);
    }

    @Override
    public State apply(State state, double scoreDelta) {
        Tree tagNode = state.sentence.get(state.tokenPosition);
        if (!tagNode.isPreTerminal()) {
            throw new AssertionError((Object)"Only expected preterminal nodes");
        }
        Tree wordNode = tagNode.children()[0];
        String word = wordNode.label().value();
        return new State(state.stack.push(tagNode), state.transitions.push(this), state.separators, state.sentence, state.tokenPosition + 1, state.score + scoreDelta, false);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof ShiftTransition;
    }

    public int hashCode() {
        return 900967388;
    }

    public String toString() {
        return "Shift";
    }
}

