/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.LabeledConstituent;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TreeSpanScoring {
    private TreeSpanScoring() {
    }

    public static int countSpanErrors(TreebankLanguagePack tlp, Tree goldTree, Tree guessTree) {
        Set<Constituent> goldConstituents = goldTree.constituents(LabeledConstituent.factory());
        Set<Constituent> guessConstituents = guessTree.constituents(LabeledConstituent.factory());
        Set<Constituent> simpleGoldConstituents = TreeSpanScoring.simplifyConstituents(tlp, goldConstituents);
        Set<Constituent> simpleGuessConstituents = TreeSpanScoring.simplifyConstituents(tlp, guessConstituents);
        int errors = 0;
        for (Constituent gold : simpleGoldConstituents) {
            if (simpleGuessConstituents.contains(gold)) continue;
            ++errors;
        }
        for (Constituent guess : simpleGuessConstituents) {
            if (simpleGoldConstituents.contains(guess)) continue;
            ++errors;
        }
        ArrayList<TaggedWord> goldWords = goldTree.taggedYield();
        ArrayList<TaggedWord> guessWords = guessTree.taggedYield();
        int len = Math.min(goldWords.size(), guessWords.size());
        for (int i = 0; i < len; ++i) {
            String guessTag;
            String goldTag = tlp.basicCategory(((TaggedWord)goldWords.get(i)).tag());
            if (goldTag.equals(guessTag = tlp.basicCategory(((TaggedWord)guessWords.get(i)).tag()))) continue;
            errors += 2;
        }
        return errors;
    }

    public static Set<Constituent> simplifyConstituents(TreebankLanguagePack tlp, Set<Constituent> constituents) {
        HashSet<Constituent> newConstituents = new HashSet<Constituent>();
        for (Constituent con : constituents) {
            if (!(con instanceof LabeledConstituent)) {
                throw new AssertionError((Object)("Unexpected constituent type " + con.getClass()));
            }
            LabeledConstituent labeled = (LabeledConstituent)con;
            newConstituents.add(new LabeledConstituent(labeled.start(), labeled.end(), tlp.basicCategory(labeled.value())));
        }
        return newConstituents;
    }
}

