# Constrained dialogue generation

This codebase contains the code for constrained dialogue generation.
We include files to run the approach as well as the public datasets we run experiments on.

# Data
- ABCD
  - Download the dataset from `https://github.com/asappresearch/abcd/blob/master/data/abcd_v1.1.json.gz` into `data/ABCD`
  - Extract the gzip file
- MultiWoz
  - Download the dataset from `https://github.com/lexmen318/MultiWOZ-coref` into `data/MultiWoz`
  - Extract the files
  - Run the `preprocess_multiwoz.py` script
- TaskMaster-3
  - Download the dataset from `https://github.com/google-research-datasets/Taskmaster/tree/master/TM-3-2020` into `data/TaskMaster`
  - Run preprocessing
    - `python preprocess_taskmaster.py --data-dir path_to_data --output-file taskmaster_processed.json`

# Fine-tune a model on the data
- Example for ABCD
  - Train the customer model first
    - ```shell
      cd finetune
      python main.py --do-train --config-file experiment_configs/abcd.ini --local-rank -1
      ```
  - Evaluate the model checkpoints
    - ```shell
      python main.py --nodo-train --do-eval --local-rank -1 --config-file experiment_configs/abcd.ini
      ```
    - make sure `evaluate_all_checkpoints` and `evaluation_metrics` keys in the config are set properly

  - Similarly train an agent model as well by changing the `train_task` to `agent` in the config file

# Build Datastore
- Example for ABCD
  - Create the train datastore
    - ```shell
      cd datastore
      model_path="Enter path to the customer model here"
      python knn_datastore.py \
             --build-datastore \
             --model_path "${model_path}" \
             --data-path data/ABCD/abcd_v1.1.json \
             --output-dir data/ABCD/KNN-DATASTORE \
             --split train \
             --finetuned \
             --fp16
      ```
  - Create the test datastore
    - ```shell
      model_path="Enter path to the customer model here"
      python knn_datastore.py \
             --build-datastore \
             --model_path "${model_path}" \
             --data-path data/ABCD/abcd_v1.1.json \
             --output-dir data/ABCD/KNN-DATASTORE \
             --split test \
             --finetuned \
             --fp16
      ```
      
# Running the approaches
- Example for ABCD
  - ```
      best_checkpoint="Enter the best Checkpoint number here"
      bash run_individual.sh \
           --run-approaches=retrievaldbs,prompt,retrieve,fop,dbs \
           --MODEL-TYPE=finetuned \
           --MODEL-PATH="simple-abcd-finetuned-customer/checkpoint-${best_checkpoint}/" \
           --config-file=experiment_configs/abcd.ini \
           --data-dir=data/ABCD/ \
           --save-dir=comparison_outputs
      ```
      
### Plot graphs (in case there is a need to plot outside of the bash script)
- `python plot.py --save_dir <results directory> --eval_type real`
- `python plot.py --save_dir <results directory> --eval_type simulated`

####** You can follow a similar set of steps for other datasets too with the corresponding config files **