
# bash wikilingua_oracle_rouge.sh /home/tiger/WikiLingua english en

DATADIR="$1"
LG="$2"
LG_SYMBOL="$3"

local_dir=~/wikilingua_oracle_${LG}
prefix=hdfs://haruna/home/byte_arnold_hl_mlnlc/user/wuxianze.0

export PYROUGE_HOME_DIR=$(pwd)/RELEASE-1.5.5
export PYROUGE_TEMP_PATH=/opt/tiger

pyrouge_set_rouge_path $PYROUGE_HOME_DIR
chmod +x $PYROUGE_HOME_DIR/ROUGE-1.5.5.pl

if [ ! -e ${local_dir} ]; then
    mkdir -p ${local_dir}
fi

hadoop fs -get ${prefix}/Datasets/multilingual/wikilingua/enzh/${LG}/test.${LG}.sum ${local_dir}
python3 utils/preData.py -m oracleLabel2Txt -i ${DATADIR}/test.label.jsonl -o ${local_dir}/oracle.txt

python3 utils/calRouge.py \
-c ${local_dir}/"oracle.txt" \
-r ${local_dir}/test.${LG}.sum \
-l ${LG_SYMBOL} -d "<q>"
