import os
import time
import datetime
import re
import argparse
import sys
import random

import json

sys.path.append("..")
from utils.logConfig import Log

random.seed(666)


def readTxt(name):
    logger.info("Reading file %s", name)
    data = []
    with open(name) as fin:
        for line in fin:
            data.append(line.replace(u'\u2028', '').replace('\r', '').strip())
    return data

def saveTxt(name, data):
    logger.info("Saving data with size %d to file %s", len(data), name)
    with open(name, 'w') as fout:
        for d in data:
            fout.write(d + "\n")

if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('-i', type=str, default='doc.txt', help='document path')
    parser.add_argument('-s', type=str, default='sum.txt', help='multi sum path')
    parser.add_argument('-c', '--count', type=int, default=2, help='select sentence number')
    parser.add_argument('-d', '--delimiter', type=str, default='<q>', help='delimiter for document')
    args = parser.parse_args()

    logger = Log.getLogger(os.path.basename(sys.argv[0]), None)
    logger.info(args)

    data = readTxt(args.i)
    docs = [doc.split(args.delimiter) for doc in data]
    leads = readTxt(args.s)
    leads = [summ.split(args.delimiter) for summ in leads]
    
    shuffle_docs = []
    for doc, summ in zip(docs, leads):
        shuffle_doc = doc[args.count:]
        shuffle_doc.extend(summ)
        random.shuffle(shuffle_doc)
        shuffle_docs.append(" <q> ".join(shuffle_doc))

    saveTxt(args.i.replace("doc", "shuffle.doc"), shuffle_docs)
    



    

    