"""Runfile for sentiment experiment."""

from absl import app
from absl import flags

from typing import Sequence
import os

from runner import ExperimentRunner

FLAGS = flags.FLAGS
flags.DEFINE_string('input_path', 'positive-sentiment.txt', 'Newline delimited file of input sentences.')
flags.DEFINE_enum('model_type', 'gpt3', ['gpt3', 'LLM', 'LLM-dialog'], 'Which model to use.')
flags.DEFINE_string('transformation', 'more negative', 'Description of how the text should be rewritten. See runner.py for examples.')
flags.DEFINE_string('transformation_name', None, 'Optional name of the transform (for the output file)')
flags.DEFINE_enum('fewshot_sentiment_direction', None, ['postoneg', 'negtopos'], 'Optional key for few shot sentiment prompts. Setting this will then *only* use the few shot prompt, not the augmented zero shot prompt.')
flags.DEFINE_bool('is_zero_shot', False, 'Whether to only use the normal zero shot (not augmented zero shot) prompt.')
flags.DEFINE_string('gpt3_key', None, 'Key for GPT3 model')
flags.DEFINE_string('gpt3_engine', 'ada', 'Which gpt3 model to use')

def main(argv):
  runner = ExperimentRunner()
  transformation_name = FLAGS.transformation_name or '_'.join(FLAGS.transformation.split(' '))
  runner.run_experiment(
    input_path=FLAGS.input_path,
    model_type=FLAGS.model_type,
    transformation=FLAGS.transformation,
    transformation_name=transformation_name,
    dataset=FLAGS.input_path,
    fewshot_sentiment_direction=FLAGS.fewshot_sentiment_direction,
    is_zero_shot=FLAGS.is_zero_shot,
    gpt3_key=FLAGS.gpt3_key,
    gpt3_engine=FLAGS.gpt3_engine)

if __name__ == '__main__':
  app.run(main)