#!/bin/bash

source "batch_jobs/_experiment_configuration.sh"

for model in ${masked_lm_models[@]}; do
    experiment_id="perplexity_m-${model}_c-${model_to_model_name_or_path[${model}]}"
    if [ ! -f "${persistent_dir}/checkpoints/${experiment_id}/results.json" ]; then
        echo ${experiment_id}
        sbatch \
            --time "04:00:00" \
            -J ${experiment_id} \
            -o $HOME/scratch/debias-eval/logs/%x.%j.out \
            -e $HOME/scratch/debias-eval/logs/%x.%j.err \
            python_job.sh experiments/run_mlm_no_trainer.py \
                --model ${model} \
                --model_name_or_path ${model_to_model_name_or_path[${model}]} \
                --dataset_name "wikitext" \
                --dataset_config_name "wikitext-2-raw-v1" \
                --per_device_eval_batch_size 1 \
                --max_seq_length 488 \
                --line_by_line True \
                --output_dir "${persistent_dir}/checkpoints/${experiment_id}" \
                --seed 0
    fi
done



for model in ${self_debias_masked_lm_models[@]}; do
    for bias_type in ${bias_types[@]}; do
        experiment_id="perplexity_m-${model}_c-${model_to_model_name_or_path[${model}]}_t-${bias_type}"
        if [ ! -f "${persistent_dir}/checkpoints/${experiment_id}/results.json" ]; then
            echo ${experiment_id}
            sbatch \
                --time "04:00:00" \
                -J ${experiment_id} \
                -o $HOME/scratch/debias-eval/logs/%x.%j.out \
                -e $HOME/scratch/debias-eval/logs/%x.%j.err \
                python_job.sh experiments/run_mlm_no_trainer.py \
                    --model ${model} \
                    --model_name_or_path ${model_to_model_name_or_path[${model}]} \
                    --dataset_name "wikitext" \
                    --dataset_config_name "wikitext-2-raw-v1" \
                    --per_device_eval_batch_size 1 \
                    --max_seq_length 488 \
                    --line_by_line True \
                    --bias_type ${bias_type} \
                    --output_dir "${persistent_dir}/checkpoints/${experiment_id}" \
                    --is_self_debias \
                    --seed 0
        fi
    done
done


for model in ${inlp_masked_lm_models[@]}; do
    for bias_type in ${bias_types[@]}; do
        experiment_id="perplexity_m-${model}_c-${model_to_model_name_or_path[${model}]}_t-${bias_type}"
        if [ ! -f "${persistent_dir}/checkpoints/${experiment_id}/results.json" ]; then
            echo ${experiment_id}
            sbatch \
                --time "04:00:00" \
                -J ${experiment_id} \
                -o $HOME/scratch/debias-eval/logs/%x.%j.out \
                -e $HOME/scratch/debias-eval/logs/%x.%j.err \
                python_job.sh experiments/run_mlm_no_trainer.py \
                    --model ${model} \
                    --model_name_or_path ${model_to_model_name_or_path[${model}]} \
                    --dataset_name "wikitext" \
                    --dataset_config_name "wikitext-2-raw-v1" \
                    --per_device_eval_batch_size 1 \
                    --max_seq_length 488 \
                    --line_by_line True \
                    --projection_matrix "${persistent_dir}/results/projection_matrix/projection_m-${debiased_model_to_base_model[${model}]}_c-${model_to_model_name_or_path[${model}]}_t-${bias_type}_r-mean.pt" \
                    --bias_type ${bias_type} \
                    --output_dir "${persistent_dir}/checkpoints/${experiment_id}" \
                    --seed 0
        fi
    done
done


for model in ${cda_masked_lm_models[@]}; do
    for bias_type in ${bias_types[@]}; do
        experiment_id="perplexity_m-${model}_c-${model_to_model_name_or_path[${model}]}_t-${bias_type}"
        if [ ! -f "${persistent_dir}/checkpoints/${experiment_id}/results.json" ]; then
            echo ${experiment_id}
            sbatch \
                --time "04:00:00" \
                -J ${experiment_id} \
                -o $HOME/scratch/debias-eval/logs/%x.%j.out \
                -e $HOME/scratch/debias-eval/logs/%x.%j.err \
                python_job.sh experiments/run_mlm_no_trainer.py \
                    --model ${model} \
                    --model_name_or_path "${persistent_dir}/checkpoints/cda_m-${debiased_model_to_masked_lm_model[${model}]}_c-${model_to_model_name_or_path[${model}]}_t-${bias_type}" \
                    --dataset_name "wikitext" \
                    --dataset_config_name "wikitext-2-raw-v1" \
                    --per_device_eval_batch_size 1 \
                    --max_seq_length 488 \
                    --line_by_line True \
                    --bias_type ${bias_type} \
                    --output_dir "${persistent_dir}/checkpoints/${experiment_id}" \
                    --seed 0
        fi
    done
done


for model in ${dropout_masked_lm_models[@]}; do
    experiment_id="perplexity_m-${model}_c-${model_to_model_name_or_path[${model}]}"
    if [ ! -f "${persistent_dir}/checkpoints/${experiment_id}/results.json" ]; then
        echo ${experiment_id}
        sbatch \
            --time "04:00:00" \
            -J ${experiment_id} \
            -o $HOME/scratch/debias-eval/logs/%x.%j.out \
            -e $HOME/scratch/debias-eval/logs/%x.%j.err \
            python_job.sh experiments/run_mlm_no_trainer.py \
                --model ${model} \
                --model_name_or_path "${persistent_dir}/checkpoints/dropout_m-${debiased_model_to_masked_lm_model[${model}]}_c-${model_to_model_name_or_path[${model}]}" \
                --dataset_name "wikitext" \
                --dataset_config_name "wikitext-2-raw-v1" \
                --per_device_eval_batch_size 1 \
                --max_seq_length 488 \
                --line_by_line True \
                --output_dir "${persistent_dir}/checkpoints/${experiment_id}" \
                --seed 0
    fi
done


for model in ${sentence_debias_masked_lm_models[@]}; do
    for bias_type in ${bias_types[@]}; do
        experiment_id="perplexity_m-${model}_c-${model_to_model_name_or_path[${model}]}_t-${bias_type}"
        if [ ! -f "${persistent_dir}/checkpoints/${experiment_id}/results.json" ]; then
            echo ${experiment_id}
            sbatch \
                --time "04:00:00" \
                -J ${experiment_id} \
                -o $HOME/scratch/debias-eval/logs/%x.%j.out \
                -e $HOME/scratch/debias-eval/logs/%x.%j.err \
                python_job.sh experiments/run_mlm_no_trainer.py \
                    --model ${model} \
                    --model_name_or_path ${model_to_model_name_or_path[${model}]} \
                    --dataset_name "wikitext" \
                    --dataset_config_name "wikitext-2-raw-v1" \
                    --per_device_eval_batch_size 1 \
                    --max_seq_length 488 \
                    --line_by_line True \
                    --bias_direction "${persistent_dir}/results/subspace/subspace_m-${debiased_model_to_base_model[${model}]}_c-${model_to_model_name_or_path[${model}]}_t-${bias_type}_r-mean.pt" \
                    --bias_type ${bias_type} \
                    --output_dir "${persistent_dir}/checkpoints/${experiment_id}" \
                    --seed 0
        fi
    done
done
