'''
- timestamp.py
- This file handles general timestamping operations
'''

# External imports
from datetime import datetime

# Internal imports


'''
----------create----------
- Creates a new timestamp for the current system time
-----Inputs-----
- format - (Optional) The string format to return (Defaults to datetime)
-----Output-----
- timestamp - The string-formatted timestamp
'''
def create(format = "datetime"):
    if format == "date":
        return datetime.now().strftime("%m-%d-%Y")
    elif format == "time":
        return datetime.now().strftime("%H-%M")
    else:
        return datetime.now().strftime("%m-%d-%Y_%H-%M")