# This script is meant to re-construct the fold's evaluation set for us to use


# Internal Imports

# External Imports


def main():
    files = [
        "analogy_task-fold1",
        "analogy_task-fold2",
        "analogy_task-fold3",
        "analogy_task-fold4",
        "analogy_task-fold5"
    ]
    full_set = "analogy_task"
    ext = ".txt"
    
    # Repeat these steps for each file
    for file in files:
        # Read in the fragment
        print("PREPARATION: Reading in fragment file: " + file)
        fragment = import_file(file, ext)

        # Read in the full set
        print("PREPARATION: Reading in full set: " + full_set)
        carving_list = import_file(full_set, ext)

        # Process the full set, removing items for each item in the fragment
        print("PROCESSING: Compiling evaluation set for " + file)
        for item in fragment:
            # For each item in the fragment list, remove it from the full carving list
            # What is left will be our testing set
            carving_list.remove(item)
        
        # Write the testing set to a file
        with open(file + "-test" + ext, "w") as output_file:
            for item in carving_list:
                output_file.write(item + "\n")
            output_file.close()



def import_file(filename, extension):
    result = []
    with open(filename + extension) as input_file:
        for line in input_file:
            if (line[0] != ":"):
                result.append(line.strip())
        input_file.close()
    return result



if __name__ == "__main__":
    main()