/*
 * Decompiled with CFR 0.152.
 */
package se.liu.ida.nlp.sdp.toolkit.graph;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import se.liu.ida.nlp.sdp.toolkit.graph.Edge;
import se.liu.ida.nlp.sdp.toolkit.graph.Node;

public class Graph {
    private final List<Node> nodes;
    private final List<Edge> edges;
    public final String id;

    public Graph(String id) {
        this.id = id;
        this.nodes = new ArrayList<Node>();
        this.edges = new ArrayList<Edge>();
    }

    public Node addNode(String form, String lemma, String pos, boolean isTop, boolean isPred, String sense) {
        Node node = new Node(this.nodes.size(), form, lemma, pos, isTop, isPred, sense);
        this.nodes.add(node);
        return node;
    }

    public Edge addEdge(int source, int target, String label) {
        assert (0 <= source && source < this.nodes.size());
        assert (0 <= target && target < this.nodes.size());
        Edge edge = new Edge(this.edges.size(), source, target, label);
        this.edges.add(edge);
        this.nodes.get(source).addOutgoingEdge(edge);
        this.nodes.get(target).addIncomingEdge(edge);
        return edge;
    }

    public int getNNodes() {
        return this.nodes.size();
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Node getNode(int node) {
        assert (0 <= node && node < this.nodes.size());
        return this.nodes.get(node);
    }

    public int getNEdges() {
        return this.edges.size();
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Edge getEdge(int edge) {
        assert (0 <= edge && edge < this.edges.size());
        return this.edges.get(edge);
    }

    public List<Node> getTops() {
        LinkedList<Node> roots = new LinkedList<Node>();
        for (Node node : this.nodes) {
            if (!node.isTop) continue;
            roots.add(node);
        }
        return roots;
    }

    public List<Node> getPreds() {
        LinkedList<Node> preds = new LinkedList<Node>();
        for (Node node : this.nodes) {
            if (!node.isPred) continue;
            preds.add(node);
        }
        return preds;
    }
}

