%clc
clear
%%%%%%data
disp('Train the FOFE-RL-DNN-LM-n-gram on WIKI database');
%%%%%%%%%%
word2vector_init_method  = 'random';
para.n_words         = 1;
para.vecSize         = 200;
%% Data prepcessing
%[D] = DataProcessing(para.vecSize, para.n_words, word2vector_init_method);
load('../data/FOFE.WIKI.80k.random.n_word1.size200.mat')
%%%%%%%%%% parameters setting
para.lrate           = 0.4;
para.batchSize       = 500;
para.alpha           = 0.6;
para.NNsize          = [para.n_words*para.vecSize,400,400,D.codeBookSize]; %% net architecture
para
%%%%%%%%%%training
[net,codeBook, obj] = FOFE_RL_DNN_LM(D, para);
%%%%%%%%%%save
nLayers = length(para.NNsize);
w = cell(1,nLayers-1);
bias = cell(1,nLayers-1);
for iLayer = 1 : nLayers-1
    w{iLayer} = gather(net.w{iLayer});
    bias{iLayer} = gather(net.b{iLayer});
end
%fname=datestr(now);
fname = sprintf('./rec/FOFE.WIKI.80k.vecSize%d_n_words%d_lr%.2f_b%d_2hid400_%s_%.2f',para.vecSize,para.n_words,para.lrate,para.batchSize,word2vector_init_method,para.alpha);
save(fname, 'w', 'bias','obj','para','codeBook') ;   