/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.pear.dag;

import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.io.FileFilters;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import edu.pku.coli.pear.dag.tran.AbstractAction;
import edu.pku.coli.treeapprox.DAG2TreeBFS;
import edu.pku.coli.treeapprox.DAG2TreeDFS;
import edu.pku.coli.treeapprox.DAG2TreeDFS_ForwardEdgeFirst;
import edu.pku.coli.treeapprox.DAG2TreeNonProjectiveSimple;
import edu.pku.coli.treeapprox.DAG2TreeProjectiveSimple;
import edu.pku.coli.treeapprox.DAG2TreeTransformer;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DAGStats
implements Runnable {
    @Option
    public String pargDir = null;
    @Option
    public String conll08Dir = null;
    @Option
    public String autoDir = null;
    @Option
    public String conll06Dir = null;
    @Option
    public String xmlDir = null;
    @Option
    public String sdpDir = null;
    @Option
    public boolean asTree = false;
    @Option
    public String out = null;
    @Option
    public boolean reverse = false;
    @Option
    public String sections = "all";
    FileFilter _sectionFileFilter = FileFilters.sectionFileFilter();
    List<DAG2TreeTransformer> d2ts = new ArrayList<DAG2TreeTransformer>();
    Set<String> labSet = new HashSet<String>();
    Set<String> treeLabSet = new HashSet<String>();
    int arcNum = 0;
    int crossArcPairNum = 0;
    private int allSents = 0;
    private int sentWithcrossingArcs = 0;

    public DAGStats() {
        this.d2ts.add(new DAG2TreeBFS(false, "both", "distance"));
        this.d2ts.add(new DAG2TreeBFS(true, "both", "distance"));
        this.d2ts.add(new DAG2TreeDFS(false, "both", "distance"));
        this.d2ts.add(new DAG2TreeDFS_ForwardEdgeFirst(false, "both", "distance"));
        this.d2ts.add(new DAG2TreeDFS_ForwardEdgeFirst(true, "both", "distance"));
        this.d2ts.add(new DAG2TreeNonProjectiveSimple(false));
        this.d2ts.add(new DAG2TreeNonProjectiveSimple(true));
        this.d2ts.add(new DAG2TreeProjectiveSimple(false));
        this.d2ts.add(new DAG2TreeProjectiveSimple(true));
    }

    public static void main(String[] args) {
        Execution.run(args, new DAGStats());
    }

    @Override
    public void run() {
        DAGSentenceReader dagReader = this.getDagReader();
        this.analys(dagReader);
    }

    private void analys(Iterable<SentenceForDAGParsing> dagReader) {
        ArrayList actions = new ArrayList();
        ArrayList<Integer> actionCovered = new ArrayList<Integer>();
        for (AbstractAction action : actions) {
            actionCovered.add(0);
        }
        for (SentenceForDAGParsing sent : dagReader) {
            ++this.allSents;
            PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
            Set<Pair<Pair<Integer, Integer>, String>> arcs = dag.toLabeledPairs();
            this.arcNum += arcs.size();
            this.crossArcPairNum += dag.crossingArcPairCount();
            if (dag.crossingArcPairCount() > 0) {
                ++this.sentWithcrossingArcs;
            }
            for (Pair<Pair<Integer, Integer>, String> arc : arcs) {
                this.labSet.add(arc.getSecond());
            }
            int i = 0;
            while (i < actions.size()) {
                AbstractAction action = (AbstractAction)actions.get(i);
                if (action.getOracleActions(dag) != null) {
                    actionCovered.set(i, (Integer)actionCovered.get(i) + 1);
                }
                ++i;
            }
        }
        LogInfo.logs("num of label types: " + this.labSet.size() + " : " + this.labSet);
        LogInfo.logs("arcs : " + this.arcNum);
        LogInfo.logs("crossing pairs : " + this.crossArcPairNum);
        LogInfo.logs("crossing sents / all = " + this.sentWithcrossingArcs + " / " + this.allSents + " = " + (double)this.sentWithcrossingArcs * 1.0 / (double)this.allSents);
        int i = 0;
        while (i < actions.size()) {
            AbstractAction action = (AbstractAction)actions.get(i);
            int covered = (Integer)actionCovered.get(i);
            LogInfo.logs(String.valueOf(action.getClass().getSimpleName()) + " covered sents = " + covered);
            ++i;
        }
    }

    private DAGSentenceReader getDagReader() {
        if (this.asTree) {
            if (this.conll08Dir != null) {
                return DAGSentenceReader.treesReaderFromCoNLL08(this.conll08Dir);
            }
            if (this.conll06Dir != null) {
                return DAGSentenceReader.treesReaderFromCoNLL06(this.conll06Dir);
            }
        } else {
            if (this.conll08Dir != null) {
                return DAGSentenceReader.dagsReaderFromCoNLL08(this.conll08Dir, false);
            }
            if (this.conll06Dir != null) {
                return DAGSentenceReader.dagsReaderFromPARGwithCoNLL06(new File(this.pargDir), new File(this.conll06Dir), false);
            }
            if (this.autoDir != null) {
                return DAGSentenceReader.dagsReaderFromPARGwithCCGBank(new File(this.pargDir), this._sectionFileFilter, new File(this.autoDir), this._sectionFileFilter);
            }
            if (this.xmlDir != null) {
                return DAGSentenceReader.dagsReaderFromXML(this.xmlDir, false);
            }
            if (this.sdpDir != null) {
                return DAGSentenceReader.dagsReaderFromSDP(this.sdpDir);
            }
        }
        return null;
    }
}

