///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>

#include "nl-iomacros.h"
#include "nl-cpt.h"

///////////////////////////////////////////////////////////////////////////////


//////////

char psX[]="";
char psComma[]=",";
char psColon[]=":";
char psSpace[]=" ";
char psLBrace[]="{";
char psRBrace[]="}";


//////////

DiscreteDomain<int> domU;
typedef DiscreteDomainRV<int,domU> U;
const U U_L("l");
const U U_R("r");

DiscreteDomain<int> domD;
typedef DiscreteDomainRV<int,domD> D;
const D D_0("0");
const D D_1("1");
const D D_2("2");
const D D_3("3");
const D D_4("4");
const D D_5("5");

DiscreteDomain<int> domL;
typedef DiscreteDomainRV<int,domL> L;
const L L_TOP("h");

DiscreteDomain<int> domC;
typedef DiscreteDomainRV<int,domC> C;
const C C_TOP("REST");

DiscreteDomain<int> domI;
typedef DiscreteDomainRV<int,domI> I;
const I I_TOP("-");

DiscreteDomain<int> domH;
typedef DiscreteDomainRV<int,domH> H;

DiscreteDomain<int> domF;
typedef DiscreteDomainRV<int,domF> F;


//////////

typedef DelimitedJoint2DRV<psX,L,psColon,C,psX> LC;
const LC LC_TOP(L_TOP,C_TOP);
typedef DelimitedJoint2DRV<psX,F,psComma,LC,psX> FLC;
typedef DelimitedJoint2DRV<psX,LC,psLBrace,I,psRBrace> LCI;
const LCI LCI_TOP(LC_TOP,I_TOP);
typedef DelimitedJoint2DRV<psX,LC,psSpace,LC,psX> LCLC;


//////////

typedef CPT4DModel<LCLC,U,D,LCI,Prob> MModel;
///typedef CPT3DModel<I,L,I,Prob>        LModel;
typedef CPT5DModel<I,U,D,L,I,Prob>    LModel;

typedef CPT4DModel<LCI,U,D,LCI,Prob>  MLModel;
typedef CPT3DModel<LCI,D,LCI,Prob>    LCIstarModel;

typedef CPT1DModel<LCI,Prob>            GrModel;
typedef CPT4DModel<FLC,D,LCI,LCI,Prob>  FGdgigiModel;
typedef CPT3DModel<LC,D,LCI,Prob>       GdgiModel;
typedef CPT4DModel<LC,D,LCI,LCI,Prob>   GdgigiModel;
typedef CPT4DModel<I,D,LC,LCI,Prob>     IdggiModel;
typedef CPT5DModel<I,D,LC,LCI,LCI,Prob> IdggigiModel;


///////////////////////////////////////////////////////////////////////////////

int main (int nArgs, char* argv[]) {

  const int NUM_ITERS = (nArgs>=2) ? atoi(argv[1]) : 10;


  //////////

  GrModel modGr;
  MModel  modM;
  LModel  modL;

  // Read in models...
  FILE* pf = stdin; assert(pf);                                                // READ MODEL FILE
  cerr << "Loading model...\n";
  int c=' '; int i=0; int line=1; Array<char*> aps(100); String sBuff(1000);   // Lookahead/ctrs/buffers
  CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                   // Get to first record
  while ( c!=-1 && c!='\0' && c!='\5' ) {                                      // For each record
    CONSUME_STR ( pf, c, (c!='\n' && c!='\0' && c!='\5'), sBuff, i, line );    //   Consume line
    StringInput si(sBuff.c_array());
    if ( !( sBuff[0]=='#' ||                                                   //   Accept comments/fields
            si>>"Gr ">>modGr>>"\0"!=NULL || 
            si>>"M ">>modM>>"\0"!=NULL || 
            si>>"L ">>modL>>"\0"!=NULL ) )
      ;//cerr<<"\nERROR: can't parse \'"<<sBuff<<"\' in line "<<line<<"\n\n";
    CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                 //   Consume whitespace
    if ( line%100000==0 ) cerr<<"  "<<line<<" lines read...\n";                //   Progress for big models
  }


  //////////

  // Add Gr as M,L at depth 0...
  const GrModel::distribution& distGr = modGr.getDist();
  for ( GrModel::distribution::const_iterator itdGr = distGr.begin(); itdGr != distGr.end(); ++itdGr ) {
    const LC& lc_  = itdGr->first.first;
    const L&  l_   = itdGr->first.first.first;
    const I&  i_   = itdGr->first.second;
    Prob  prGr = itdGr->second;
    modM.setProb(LCLC(lc_,LC_TOP),U_R,D_0,LCI_TOP) += prGr;
    ///modL.setProb(i_,l_,I_TOP) += prGr;
    modL.setProb(i_,U_L,D_1,l_,I_TOP) += prGr;
  }
  modL.normalize();  // b/c part of derived condition (l_) not const or in initial condition (which for Gr is empty)...

  LCIstarModel modLCIstar;
  LCIstarModel modLCIzero;
  LCIstarModel modLCIplus;
  MLModel modML;
  LCIstarModel modLCI[2];

  // Define P_ML(lci_0|udlci_) = SUM lc_1 . P_M(lc_0,lc_1|udlci_) * P_L(i_0|l_0,i_)...
  for ( MModel::const_iterator itM = modM.begin(); itM != modM.end(); ++itM ) {
    const U&   u_   = itM->first.getX1();
    const D&   d_   = itM->first.getX2();
    const LCI& lci_ = itM->first.getX3();
    const I&   i_   = itM->first.getX3().second;
    const MModel::distribution& distM = itM->second;
    for ( MModel::distribution::const_iterator itdM = distM.begin(); itdM != distM.end(); ++itdM ) {
      const LC& lc_0 = itdM->first.first;
      const L&  l_0  = itdM->first.first.first;
      Prob      prM  = itdM->second;
      if ( U_L == u_ ) {
        ///const LModel::distribution& distL = modL.getDist(l_0,i_);
        const LModel::distribution& distL = modL.getDist(U_L,d_,l_0,i_);
        for ( LModel::distribution::const_iterator itdL = distL.begin(); itdL != distL.end(); ++itdL ) {
          const I& i_0 = itdL->first;
          Prob     prL = itdL->second;
          LCI lci_0 (lc_0,i_0);
          modML.setProb(lci_0,u_,d_,lci_) += (prM * prL);
        }
      } else {
        ///const LModel::distribution& distL = modL.getDist(l_0,i_);
        const LModel::distribution& distL = modL.getDist(U_L,D(d_.toInt()+1),l_0,i_);
        for ( LModel::distribution::const_iterator itdL = distL.begin(); itdL != distL.end(); ++itdL ) {
          const I& i_0 = itdL->first;
          Prob     prL = itdL->second;
          LCI lci_0 (lc_0,i_0);
          modLCI[0].setProb (lci_0,D(d_.toInt()+1),lci_) += (prM * prL);
          modLCIzero.setProb(lci_0,D(d_.toInt()+1),lci_) += (prM * prL);
          modLCIstar.setProb(lci_0,D(d_.toInt()+1),lci_) += (prM * prL);
        }
      }
    }
  }

  // Define P_LCIk(lci_0k0|lci_) = SUM lci_0k . P_LCIk-1(lci_0k|lci_) * P_ML(lci_0k0|u_,d_,lci_0k)...
  for ( int k=1; k<=NUM_ITERS; k++ ) {
    cerr<<"k="<<k<<"...\n";
    for ( LCIstarModel::const_iterator itLCI = modLCI[(k-1)%2].begin(); itLCI != modLCI[(k-1)%2].end(); ++itLCI ) {
      const D&   d_   = itLCI->first.getX1();
      const LCI& lci_ = itLCI->first.getX2();
      const LCIstarModel::distribution& distLCI = itLCI->second;
      for ( LCIstarModel::distribution::const_iterator itdLCI = distLCI.begin(); itdLCI != distLCI.end(); ++itdLCI ) {
        const LCI& lci_0k = itdLCI->first;
        Prob       prLCI  = itdLCI->second;
        const MLModel::distribution& distML = modML.getDist(U_L,d_,lci_0k);
        for ( MLModel::distribution::const_iterator itdML = distML.begin(); itdML != distML.end(); ++itdML ) {
          const LCI& lci_0k0 = itdML->first;
          Prob       prML    = itdML->second;
          modLCI[k%2].setProb(lci_0k0,d_,lci_) += (prLCI * prML);
          modLCIplus.setProb (lci_0k0,d_,lci_) += (prLCI * prML);
          modLCIstar.setProb (lci_0k0,d_,lci_) += (prLCI * prML);
        }
      }
    }
    modLCI[(k-1)%2].clear();
  }
  modLCI[NUM_ITERS%2].clear();

  modL.dump(cout,"L");
  modM.dump(cout,"M");
  modLCIstar.dump(cout,"G*");
  modLCIzero.dump(cout,"G0");  // could calc, but need to make sure no rounding errors
  //modLCIplus.dump(cout,"G+");
}
