###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


require 'scripts/umnlp.rb'

class Tree

  ## Get an array of 0's and 1's representing edited-ness of each word
  def getEditedArray(edited=0)
    if @children.size == 0
      return Array.new << edited
    end
    
    if @head =~ /EDITED/
      edited=1
    end
    out = Array.new
    @children.each{ |child|
      out << child.getEditedArray(edited)
    }
    return out
  end  
end

while(line=gets)
  t = Tree.new(line)
  out = t.getEditedArray
  puts out.join(" ")
end

   