/*
 * Decompiled with CFR 0.152.
 */
package babel.prep.datedcorpus;

import babel.content.pages.PageVersion;
import babel.prep.PrepStep;
import babel.prep.datedcorpus.DatedCorpusGenMapper;
import babel.prep.datedcorpus.DatedCorpusGenReducer;
import babel.prep.datedcorpus.DatedLangFilesOutputFormat;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;

public class DatedCorpusGenerator
extends PrepStep {
    protected static final Log LOG = LogFactory.getLog(DatedCorpusGenerator.class);
    protected static final String CORPUS_SUBDIR = "datedcorpus";

    protected JobConf createJobConf(String crawlDir, String pagesSubDir) throws IOException {
        JobConf job = new JobConf(this.getConf());
        job.setJobName("create dated dataset from " + pagesSubDir);
        job.setInputFormat(SequenceFileInputFormat.class);
        job.setMapperClass(DatedCorpusGenMapper.class);
        job.setReducerClass(DatedCorpusGenReducer.class);
        job.setMapOutputValueClass(PageVersion.class);
        job.setOutputFormat(DatedLangFilesOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path(crawlDir, pagesSubDir));
        Path outDir = new Path(new Path(crawlDir, CORPUS_SUBDIR), "datedcorpus." + this.getCurTimeStamp());
        this.m_fs.delete(outDir, true);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
        this.setUniqueTempDir(job);
        return job;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            DatedCorpusGenerator.usage();
            return;
        }
        DatedCorpusGenerator gen = new DatedCorpusGenerator();
        JobConf job = gen.createJobConf(args[0], args[1]);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("DatedCorpusGenerator: " + job.getJobName()));
        }
        gen.runPrepStep(job);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(String.valueOf(Stats.dumpStats()) + "\n"));
            LOG.info((Object)("Output: " + FileOutputFormat.getOutputPath((JobConf)job)));
            LOG.info((Object)"DatedCorpusGenerator: done");
        }
    }

    protected static void usage() {
        System.err.println("Usage: DatedCorpusGenerator crawl_dir pages_subdir\n");
    }

    static class Stats {
        private static HashMap<String, Long> pageVerCounts = new HashMap();
        private static HashMap<String, Long> wordCounts = new HashMap();

        Stats() {
        }

        public static synchronized void incLangPageVerCount(String lang) {
            long curCount = pageVerCounts.containsKey(lang) ? pageVerCounts.get(lang).intValue() + 1 : 1;
            pageVerCounts.put(lang, curCount);
        }

        public static synchronized void incLangWordCount(String lang, long count) {
            long curCount = wordCounts.containsKey(lang) ? (long)wordCounts.get(lang).intValue() + count : count;
            wordCounts.put(lang, curCount);
        }

        public static String dumpStats() {
            StringBuilder strBld = new StringBuilder();
            int totalCount = 0;
            for (String lang : pageVerCounts.keySet()) {
                long count = pageVerCounts.get(lang);
                strBld.append(String.valueOf(lang) + " : " + count + ", " + wordCounts.get(lang) + "\n");
                totalCount = (int)((long)totalCount + count);
            }
            strBld.append("Total page versions = " + totalCount);
            return strBld.toString();
        }
    }
}

