/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.phrases;

import babel.content.eqclasses.comparators.LexComparator;
import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.properties.context.Context;
import babel.util.misc.GettableHashSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class PhraseTable {
    protected static final String DEFAULT_CHARSET = "UTF-8";
    public static final String FIELD_DELIM = " ||| ";
    protected Map<Phrase, Map<Phrase, PairProps>> m_phraseMap;
    protected String m_encoding;
    protected boolean m_caseSensitive;
    protected int m_numPairs;
    protected String m_curFileName;
    protected BufferedReader m_curFileReader;

    public PhraseTable(String encoding, boolean caseSensitive) {
        this.m_encoding = encoding;
        this.m_phraseMap = new HashMap<Phrase, Map<Phrase, PairProps>>();
        this.m_caseSensitive = caseSensitive;
        this.m_numPairs = 0;
        this.m_curFileName = null;
        this.m_curFileReader = null;
    }

    public PhraseTable(PhraseTable table, Set<Phrase> srcToRetain, Set<Phrase> trgToRetain) {
        this(table.m_encoding, table.m_caseSensitive);
        for (Phrase srcPhrase : table.m_phraseMap.keySet()) {
            if (!srcToRetain.contains(srcPhrase)) continue;
            HashMap<Phrase, PairProps> newMap = new HashMap<Phrase, PairProps>();
            Map<Phrase, PairProps> oldMap = table.m_phraseMap.get(srcPhrase);
            if (oldMap != null) {
                for (Phrase trgPhrase : oldMap.keySet()) {
                    if (trgToRetain != null && !trgToRetain.contains(trgPhrase)) continue;
                    newMap.put(trgPhrase, oldMap.get(trgPhrase));
                    ++this.m_numPairs;
                }
            }
            if (newMap.size() <= 0) continue;
            this.m_phraseMap.put(srcPhrase, newMap);
        }
    }

    public PhraseTable(boolean caseSensitive) {
        this(DEFAULT_CHARSET, caseSensitive);
    }

    public PhraseTable(String phraseTableFile, int numLines, String encoding, boolean caseSensitive) throws IOException {
        this(encoding, caseSensitive);
        this.processPhraseTableFile(phraseTableFile, numLines);
        this.closePhraseTableFile();
    }

    public PhraseTable(String phraseTableFile, int numLines, boolean caseSensitive) throws IOException {
        this(phraseTableFile, numLines, DEFAULT_CHARSET, caseSensitive);
    }

    public PhraseTable(Set<Phrase> srcPhrases, Set<Phrase> trgPhrases, boolean caseSensitive) {
        this(caseSensitive);
        for (Phrase srcPhrase : srcPhrases) {
            for (Phrase trgPhrase : trgPhrases) {
                Map<Phrase, PairProps> trgMap = this.m_phraseMap.get(srcPhrase);
                if (trgMap == null) {
                    trgMap = new HashMap<Phrase, PairProps>();
                    this.m_phraseMap.put(srcPhrase, trgMap);
                }
                trgMap.put(trgPhrase, new PairProps(""));
                ++this.m_numPairs;
            }
        }
    }

    public Set<Phrase> getAllSingleTokenSrcPhrases() {
        HashSet<Phrase> srcPhrases = new HashSet<Phrase>();
        for (Phrase srcPhrase : this.m_phraseMap.keySet()) {
            if (srcPhrase.numTokens() != 1) continue;
            srcPhrases.add(srcPhrase);
        }
        return srcPhrases;
    }

    public Set<Phrase> getAllSingleTokenTrgPhrases() {
        HashSet<Phrase> trgPhrases = new HashSet<Phrase>();
        Set<Phrase> allTrgPhrases = this.getAllTrgPhrases();
        for (Phrase trgPhrase : allTrgPhrases) {
            if (trgPhrase.numTokens() != 1) continue;
            trgPhrases.add(trgPhrase);
        }
        return trgPhrases;
    }

    public Set<Phrase> getAllSrcPhrases() {
        return this.m_phraseMap.keySet();
    }

    public int numSrcPhrases() {
        return this.m_phraseMap.size();
    }

    public int numPhrasePairs() {
        return this.m_numPairs;
    }

    public Set<Phrase> getAllTrgPhrases() {
        HashSet<Phrase> allTrg = new HashSet<Phrase>();
        for (Map<Phrase, PairProps> trgMap : this.m_phraseMap.values()) {
            allTrg.addAll((Collection<Phrase>)trgMap.keySet());
        }
        return allTrg;
    }

    public boolean removePairsWithSrc(Phrase srcPhrase) {
        return this.m_phraseMap.remove(srcPhrase) != null;
    }

    public void removePairsWithSrc(Set<Phrase> srcPhrases) {
        for (Phrase srcPhrase : srcPhrases) {
            this.m_phraseMap.remove(srcPhrase);
        }
    }

    public Set<Phrase> getTrgPhrases(Phrase srcPhrase) {
        Set<Phrase> s = this.m_phraseMap.containsKey(srcPhrase) ? this.m_phraseMap.get(srcPhrase).keySet() : Collections.emptySet();
        return s;
    }

    public Set<Phrase> getTrgPhrases(Set<Phrase> srcPhrases) {
        HashSet<Phrase> trgPhrases = new HashSet<Phrase>();
        if (srcPhrases != null) {
            for (Phrase srcPhrase : srcPhrases) {
                if (!this.m_phraseMap.containsKey(srcPhrase)) continue;
                trgPhrases.addAll((Collection<Phrase>)this.m_phraseMap.get(srcPhrase).keySet());
            }
        }
        return trgPhrases;
    }

    public PairProps getProps(Phrase srcPhrase, Phrase trgPhrase) {
        Map<Phrase, PairProps> trgMap = this.m_phraseMap.get(srcPhrase);
        return trgMap == null ? null : trgMap.get(trgPhrase);
    }

    public void savePhraseTable(String phraseTableFile, PairFeat[] featsToWrite) throws IOException {
        this.savePhraseTableChunk(this.m_phraseMap.keySet(), phraseTableFile, featsToWrite);
    }

    public void savePhraseTableChunk(Set<Phrase> srcPhrases, String phraseTableFile, PairFeat[] featsToWrite) throws IOException {
        if (phraseTableFile != null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(phraseTableFile, true), this.m_encoding));
            ArrayList<Phrase> srcPhraseList = new ArrayList<Phrase>(srcPhrases);
            Collections.sort(srcPhraseList, new LexComparator(true));
            for (Phrase srcPhrase : srcPhraseList) {
                Map<Phrase, PairProps> trgMap = this.m_phraseMap.get(srcPhrase);
                ArrayList trgPhraseList = new ArrayList(trgMap.keySet());
                Collections.sort(trgPhraseList, new LexComparator(true));
                for (Phrase trgPhrase : trgPhraseList) {
                    writer.write(String.valueOf(srcPhrase.getStem()) + FIELD_DELIM + trgPhrase.getStem() + FIELD_DELIM + trgMap.get(trgPhrase).getPairFeatStr(featsToWrite) + "\n");
                }
            }
            writer.close();
        }
    }

    public void saveContextStatsForBen(String statsFile) throws IOException {
        if (statsFile != null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(statsFile, true), this.m_encoding));
            ArrayList srcPhraseList = new ArrayList(this.m_phraseMap.keySet());
            Collections.sort(srcPhraseList, new LexComparator(true));
            for (Phrase srcPhrase : srcPhraseList) {
                Map<Phrase, PairProps> trgMap = this.m_phraseMap.get(srcPhrase);
                ArrayList trgPhraseList = new ArrayList(trgMap.keySet());
                Collections.sort(trgPhraseList, new LexComparator(true));
                Context srcContext = (Context)srcPhrase.getProperty(Context.class.getName());
                for (Phrase trgPhrase : trgPhraseList) {
                    Context trgContext = (Context)trgPhrase.getProperty(Context.class.getName());
                    int intersection = 0;
                    for (Context.ContextualItem srcCi : srcContext.getContextualItems()) {
                        if (trgContext.getContextualItem(srcCi.getContextEqId()) == null) continue;
                        ++intersection;
                    }
                    writer.write(String.valueOf(srcPhrase.getStem()) + FIELD_DELIM + trgPhrase.getStem() + FIELD_DELIM + srcContext.size() + " " + trgContext.size() + " " + intersection + "\n");
                }
            }
            writer.close();
        }
    }

    public void saveReorderingTable(String reorderingTableFile) throws IOException {
        this.saveReorderingTableChunk(this.m_phraseMap.keySet(), reorderingTableFile);
    }

    public void saveReorderingTableChunk(Set<Phrase> srcPhrases, String reorderingTableFile) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reorderingTableFile, true), this.m_encoding));
        ArrayList<Phrase> srcPhraseList = new ArrayList<Phrase>(srcPhrases);
        Collections.sort(srcPhraseList, new LexComparator(true));
        for (Phrase srcPhrase : srcPhraseList) {
            Map<Phrase, PairProps> trgMap = this.m_phraseMap.get(srcPhrase);
            ArrayList trgPhraseList = new ArrayList(trgMap.keySet());
            Collections.sort(trgPhraseList, new LexComparator(true));
            for (Phrase trgPhrase : trgPhraseList) {
                writer.write(String.valueOf(srcPhrase.getStem()) + FIELD_DELIM + trgPhrase.getStem() + FIELD_DELIM + trgMap.get(trgPhrase).getOrderFeatStr() + "\n");
            }
        }
        writer.close();
    }

    public int processPhraseTableFile(String phraseTableFile, int numLines) throws IOException {
        if (!phraseTableFile.equals(this.m_curFileName)) {
            this.m_curFileName = phraseTableFile;
            if (this.m_curFileReader != null) {
                this.m_curFileReader.close();
            }
            InputStream is = new FileInputStream(phraseTableFile);
            if (phraseTableFile.toLowerCase().endsWith("gz")) {
                is = new GZIPInputStream(is);
            }
            this.m_curFileReader = new BufferedReader(new InputStreamReader(is, this.m_encoding));
        }
        String line = null;
        GettableHashSet<Phrase> allTrgPhrases = new GettableHashSet<Phrase>();
        int numLinesRead = 0;
        this.m_phraseMap.clear();
        this.m_numPairs = 0;
        while ((numLines < 0 || numLinesRead < numLines) && (line = this.m_curFileReader.readLine()) != null) {
            ++numLinesRead;
            if (!line.contains(FIELD_DELIM)) continue;
            int from = 0;
            int to = line.indexOf(FIELD_DELIM);
            String srcStr = line.substring(from, to);
            from = to + FIELD_DELIM.length();
            to = line.indexOf(FIELD_DELIM, from);
            String trgStr = line.substring(from, to);
            from = to + FIELD_DELIM.length();
            String pairProps = line.substring(from);
            Phrase srcPhrase = new Phrase();
            srcPhrase.init(srcStr, this.m_caseSensitive);
            Map<Phrase, PairProps> trgMap = this.m_phraseMap.get(srcPhrase);
            if (trgMap == null) {
                srcPhrase.assignId();
                trgMap = new HashMap<Phrase, PairProps>();
                this.m_phraseMap.put(srcPhrase, trgMap);
            }
            Phrase trgPhrase = new Phrase();
            trgPhrase.init(trgStr, this.m_caseSensitive);
            if (!allTrgPhrases.contains(trgPhrase)) {
                trgPhrase.assignId();
                allTrgPhrases.add(trgPhrase);
            } else {
                trgPhrase = allTrgPhrases.get(trgPhrase);
            }
            assert (!trgMap.containsKey(trgPhrase));
            trgMap.put(trgPhrase, new PairProps(pairProps));
            ++this.m_numPairs;
        }
        return numLinesRead;
    }

    public void closePhraseTableFile() throws IOException {
        if (this.m_curFileReader != null) {
            this.m_curFileReader.close();
        }
        this.m_curFileReader = null;
        this.m_curFileName = null;
    }

    public static enum PairFeat {
        FE(0),
        LEX_FE(1),
        EF(2),
        LEX_EF(3),
        PHPENALTY(4),
        PH_CONTEXT(5),
        PH_TIME(6),
        LEX_CONTEXT(7),
        LEX_TIME(8),
        LEX_EDIT(9);

        public final int idx;

        private PairFeat(int idx) {
            this.idx = idx;
        }
    }

    public class PairProps {
        protected String m_pairFeatStrPrefix;
        protected String[] m_featVals;
        protected String m_beforeOrderFeatStr;
        protected String m_afterOrderFeatStr;

        public PairProps(String pairFeatStr) {
            String[] strFeats;
            int lastDelimIdx = pairFeatStr.lastIndexOf(PhraseTable.FIELD_DELIM);
            if (lastDelimIdx < 0) {
                this.m_pairFeatStrPrefix = " |||  ||| ";
                strFeats = new String[]{};
            } else {
                this.m_pairFeatStrPrefix = pairFeatStr.substring(0, lastDelimIdx + PhraseTable.FIELD_DELIM.length());
                strFeats = pairFeatStr.substring(lastDelimIdx + PhraseTable.FIELD_DELIM.length()).split("\\s");
            }
            int maxFeats = PairFeat.values().length;
            assert (strFeats.length <= maxFeats);
            this.m_featVals = new String[maxFeats];
            int i = 0;
            while (i < strFeats.length) {
                this.m_featVals[i] = strFeats[i];
                ++i;
            }
            i = strFeats.length;
            while (i < maxFeats) {
                this.m_featVals[i] = null;
                ++i;
            }
            if (this.m_featVals[PairFeat.PHPENALTY.idx] == null) {
                this.m_featVals[PairFeat.PHPENALTY.idx] = "2.718";
            }
        }

        public void setPairFeatVal(PairFeat feat, double val) {
            this.m_featVals[feat.idx] = Double.toString(val);
        }

        public Double getPairFeatVal(PairFeat feat) {
            return this.m_featVals[feat.idx] == null ? null : Double.valueOf(Double.parseDouble(this.m_featVals[feat.idx]));
        }

        public String getPairFeatStr(PairFeat[] feats) {
            StringBuilder pairFeatStr = new StringBuilder(this.m_pairFeatStrPrefix);
            boolean first = true;
            PairFeat[] pairFeatArray = feats;
            int n = feats.length;
            int n2 = 0;
            while (n2 < n) {
                PairFeat feat = pairFeatArray[n2];
                if (!first) {
                    pairFeatStr.append(" ");
                }
                pairFeatStr.append(this.m_featVals[feat.idx] == null ? Integer.valueOf(0) : this.m_featVals[feat.idx]);
                first = false;
                ++n2;
            }
            return pairFeatStr.toString();
        }

        public void setBeforeOrderFeatVals(double beforeMono, double beforeSwap, double beforeDisc) {
            assert (beforeMono >= 0.0 && beforeSwap >= 0.0 && beforeDisc >= 0.0);
            StringBuilder featStrBld = new StringBuilder();
            featStrBld.append(String.valueOf(beforeMono) + " ");
            featStrBld.append(String.valueOf(beforeSwap) + " ");
            featStrBld.append(String.valueOf(beforeDisc) + " ");
            this.m_beforeOrderFeatStr = featStrBld.toString();
        }

        public void setAfterOrderFeatVals(double afterMono, double afterSwap, double afterDisc) {
            assert (afterMono >= 0.0 && afterSwap >= 0.0 && afterDisc >= 0.0);
            StringBuilder featStrBld = new StringBuilder();
            featStrBld.append(String.valueOf(afterMono) + " ");
            featStrBld.append(String.valueOf(afterSwap) + " ");
            featStrBld.append(afterDisc);
            this.m_afterOrderFeatStr = featStrBld.toString();
        }

        public String getOrderFeatStr() {
            String orderFeatStr = this.m_beforeOrderFeatStr != null ? this.m_beforeOrderFeatStr.toString() : "0.333333 0.333333 0.333333 ";
            orderFeatStr = String.valueOf(orderFeatStr) + (this.m_afterOrderFeatStr != null ? this.m_afterOrderFeatStr.toString() : "0.333333 0.333333 0.333333");
            return orderFeatStr;
        }

        public int[][] getForwardAligns() {
            return this.getAlignment(this.m_pairFeatStrPrefix.substring(0, this.m_pairFeatStrPrefix.indexOf(PhraseTable.FIELD_DELIM)).trim());
        }

        public int[][] getBackwardAligns() {
            return this.getAlignment(this.m_pairFeatStrPrefix.substring(this.m_pairFeatStrPrefix.indexOf(PhraseTable.FIELD_DELIM) + PhraseTable.FIELD_DELIM.length(), this.m_pairFeatStrPrefix.lastIndexOf(PhraseTable.FIELD_DELIM)).trim());
        }

        protected int[][] getAlignment(String alignStr) {
            String[] strAligns = alignStr.split(" ");
            int[][] aligns = new int[strAligns.length][];
            int i = 0;
            while (i < strAligns.length) {
                if ("()".equals(strAligns[i])) {
                    aligns[i] = null;
                } else {
                    String[] curAligns = strAligns[i].substring(1, strAligns[i].length() - 1).split(",");
                    aligns[i] = new int[curAligns.length];
                    int j = 0;
                    while (j < curAligns.length) {
                        aligns[i][j] = Integer.parseInt(curAligns[j]);
                        ++j;
                    }
                }
                ++i;
            }
            return aligns;
        }
    }
}

