/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.planar3TLabelStrat;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.planar3TLabelStrat.Planar3TLabelStratAddressFunction;
import org.maltparser.parser.algorithm.planar3TLabelStrat.Planar3TLabelStratConfig;

public abstract class Planar3TLabelStratFactory
implements AbstractParserFactory {
    protected Algorithm algorithm;
    protected DependencyParserConfig manager;

    public Planar3TLabelStratFactory(Algorithm algorithm) {
        this.setAlgorithm(algorithm);
        this.setManager(algorithm.getManager());
    }

    public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Parser configuration : Planar 3T Label Strategy with no_covered_roots = " + this.manager.getOptionValue("planar3tlab", "no_covered_roots").toString().toUpperCase() + ", " + "acyclicity = " + this.manager.getOptionValue("planar3tlab", "acyclicity").toString().toUpperCase() + ", connectedness = " + this.manager.getOptionValue("planar3tlab", "connectedness").toString().toUpperCase() + ", heuristic = " + this.manager.getOptionValue("planar3tlab", "heuristic").toString().toUpperCase() + ", " + "root handling = " + this.manager.getOptionValue("planar3tlab", "planar_root_handling").toString().toUpperCase() + "\n");
        }
        return new Planar3TLabelStratConfig(this.manager.getSymbolTables(), this.manager.getOptionValue("planar3tlab", "no_covered_roots").toString(), this.manager.getOptionValue("planar3tlab", "acyclicity").toString(), this.manager.getOptionValue("planar3tlab", "connectedness").toString(), this.manager.getOptionValue("planar3tlab", "planar_root_handling").toString(), this.manager.getOptionValue("planar3tlab", "heuristic").toString());
    }

    public Function makeFunction(String subFunctionName) throws MaltChainedException {
        return new Planar3TLabelStratAddressFunction(subFunctionName, this.algorithm);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }
}

