/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.AbstractPATNode;
import com.aliasi.lm.ArrayDtrNodeByte;
import com.aliasi.lm.ArrayDtrNodeInt;
import com.aliasi.lm.ArrayDtrNodeLong;
import com.aliasi.lm.ArrayDtrNodeShort;
import com.aliasi.lm.Node;
import com.aliasi.lm.OneDtrNodeByte;
import com.aliasi.lm.OneDtrNodeInt;
import com.aliasi.lm.OneDtrNodeLong;
import com.aliasi.lm.OneDtrNodeShort;
import com.aliasi.lm.PAT1NodeByte;
import com.aliasi.lm.PAT1NodeInt;
import com.aliasi.lm.PAT1NodeLong;
import com.aliasi.lm.PAT1NodeOne;
import com.aliasi.lm.PAT1NodeShort;
import com.aliasi.lm.PAT1NodeThree;
import com.aliasi.lm.PAT1NodeTwo;
import com.aliasi.lm.PAT2NodeByte;
import com.aliasi.lm.PAT2NodeInt;
import com.aliasi.lm.PAT2NodeLong;
import com.aliasi.lm.PAT2NodeOne;
import com.aliasi.lm.PAT2NodeShort;
import com.aliasi.lm.PAT2NodeThree;
import com.aliasi.lm.PAT2NodeTwo;
import com.aliasi.lm.PAT3NodeByte;
import com.aliasi.lm.PAT3NodeInt;
import com.aliasi.lm.PAT3NodeLong;
import com.aliasi.lm.PAT3NodeOne;
import com.aliasi.lm.PAT3NodeShort;
import com.aliasi.lm.PAT3NodeThree;
import com.aliasi.lm.PAT3NodeTwo;
import com.aliasi.lm.PAT4NodeByte;
import com.aliasi.lm.PAT4NodeInt;
import com.aliasi.lm.PAT4NodeLong;
import com.aliasi.lm.PAT4NodeOne;
import com.aliasi.lm.PAT4NodeShort;
import com.aliasi.lm.PAT4NodeThree;
import com.aliasi.lm.PAT4NodeTwo;
import com.aliasi.lm.PATArrayNodeByte;
import com.aliasi.lm.PATArrayNodeInt;
import com.aliasi.lm.PATArrayNodeLong;
import com.aliasi.lm.PATArrayNodeOne;
import com.aliasi.lm.PATArrayNodeShort;
import com.aliasi.lm.PATArrayNodeThree;
import com.aliasi.lm.PATArrayNodeTwo;
import com.aliasi.lm.TerminalNode;
import com.aliasi.lm.TerminalNodeByte;
import com.aliasi.lm.TerminalNodeInt;
import com.aliasi.lm.TerminalNodeLong;
import com.aliasi.lm.TerminalNodeShort;
import com.aliasi.lm.ThreeDtrNodeByte;
import com.aliasi.lm.ThreeDtrNodeInt;
import com.aliasi.lm.ThreeDtrNodeLong;
import com.aliasi.lm.ThreeDtrNodeShort;
import com.aliasi.lm.TwoDtrNodeByte;
import com.aliasi.lm.TwoDtrNodeInt;
import com.aliasi.lm.TwoDtrNodeLong;
import com.aliasi.lm.TwoDtrNodeShort;

class NodeFactory {
    static Node[] TERMINAL_NODES = new Node[1024];
    static Node[] EMPTY_NODES;

    NodeFactory() {
    }

    static char[] sliceToArray(char[] cs, int start, int end) {
        if (start == 0 && end == cs.length) {
            return cs;
        }
        char[] result = new char[end - start];
        for (int i = 0; i < result.length; ++i) {
            result[i] = cs[start + i];
        }
        return result;
    }

    static Node createNode(long count) {
        if (count < (long)TERMINAL_NODES.length) {
            return TERMINAL_NODES[(int)count];
        }
        return NodeFactory.createTerminalNode(count);
    }

    static Node createNode(char[] cs, int start, int end, long count) {
        switch (end - start) {
            case 0: {
                return NodeFactory.createNode(count);
            }
            case 1: {
                return NodeFactory.createNode(cs[start], count);
            }
            case 2: {
                return NodeFactory.createNode(cs[start], cs[start + 1], count);
            }
            case 3: {
                return NodeFactory.createNode(cs[start], cs[start + 1], cs[start + 2], count);
            }
            case 4: {
                return NodeFactory.createNode(cs[start], cs[start + 1], cs[start + 2], cs[start + 3], count);
            }
        }
        return NodeFactory.createPATArrayNode(NodeFactory.sliceToArray(cs, start, end), count);
    }

    static Node createNode(char[] cs, Node[] dtrs, long count) {
        switch (dtrs.length) {
            case 0: {
                return NodeFactory.createNode(count);
            }
            case 1: {
                return NodeFactory.createNode(cs[0], dtrs[0], count);
            }
            case 2: {
                return NodeFactory.createNode(cs[0], dtrs[0], cs[1], dtrs[1], count);
            }
            case 3: {
                return NodeFactory.createNode(cs[0], dtrs[0], cs[1], dtrs[1], cs[2], dtrs[2], count);
            }
        }
        return NodeFactory.createArrayDtrNode(cs, dtrs, count);
    }

    static Node createNodePrune(char[] cs, Node[] dtrs, long count) {
        int numOutcomes = 0;
        for (int i = 0; i < dtrs.length; ++i) {
            if (dtrs[i] == null) continue;
            ++numOutcomes;
        }
        if (numOutcomes == dtrs.length) {
            return NodeFactory.createNode(cs, dtrs, count);
        }
        char[] csOut = new char[numOutcomes];
        Node[] dtrsOut = new Node[numOutcomes];
        int indexOut = 0;
        for (int i = 0; i < dtrs.length; ++i) {
            if (dtrs[i] == null) continue;
            csOut[indexOut] = cs[i];
            dtrsOut[indexOut] = dtrs[i];
            ++indexOut;
        }
        return NodeFactory.createNode(csOut, dtrsOut, count);
    }

    static Node createNode(char[] cs, int start, int end, long headCount, long tailCount) {
        if (end == start) {
            return NodeFactory.createNode(headCount);
        }
        if (headCount == tailCount) {
            return NodeFactory.createNode(cs, start, end, headCount);
        }
        return NodeFactory.createNode(cs[start], NodeFactory.createNode(cs, start + 1, end, tailCount), headCount);
    }

    static Node createTerminalNode(long count) {
        if (count <= 127L) {
            return new TerminalNodeByte(count);
        }
        if (count <= 32767L) {
            return new TerminalNodeShort(count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new TerminalNodeInt(count);
        }
        return new TerminalNodeLong(count);
    }

    static Node createNode(char c, long count) {
        if (count == 1L) {
            return new PAT1NodeOne(c);
        }
        if (count == 2L) {
            return new PAT1NodeTwo(c);
        }
        if (count == 3L) {
            return new PAT1NodeThree(c);
        }
        if (count <= 127L) {
            return new PAT1NodeByte(c, count);
        }
        if (count <= 32767L) {
            return new PAT1NodeShort(c, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new PAT1NodeInt(c, count);
        }
        return new PAT1NodeLong(c, count);
    }

    static Node createNode(char c1, char c2, long count) {
        if (count == 1L) {
            return new PAT2NodeOne(c1, c2);
        }
        if (count == 2L) {
            return new PAT2NodeTwo(c1, c2);
        }
        if (count == 3L) {
            return new PAT2NodeThree(c1, c2);
        }
        if (count <= 127L) {
            return new PAT2NodeByte(c1, c2, count);
        }
        if (count <= 32767L) {
            return new PAT2NodeShort(c1, c2, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new PAT2NodeInt(c1, c2, count);
        }
        return new PAT2NodeLong(c1, c2, count);
    }

    static Node createNode(char c1, char c2, char c3, long count) {
        if (count == 1L) {
            return new PAT3NodeOne(c1, c2, c3);
        }
        if (count == 2L) {
            return new PAT3NodeTwo(c1, c2, c3);
        }
        if (count == 3L) {
            return new PAT3NodeThree(c1, c2, c3);
        }
        if (count <= 127L) {
            return new PAT3NodeByte(c1, c2, c3, count);
        }
        if (count <= 32767L) {
            return new PAT3NodeShort(c1, c2, c3, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new PAT3NodeInt(c1, c2, c3, count);
        }
        return new PAT3NodeLong(c1, c2, c3, count);
    }

    static Node createNode(char c1, char c2, char c3, char c4, long count) {
        if (count == 1L) {
            return new PAT4NodeOne(c1, c2, c3, c4);
        }
        if (count == 2L) {
            return new PAT4NodeTwo(c1, c2, c3, c4);
        }
        if (count == 3L) {
            return new PAT4NodeThree(c1, c2, c3, c4);
        }
        if (count <= 127L) {
            return new PAT4NodeByte(c1, c2, c3, c4, count);
        }
        if (count <= 32767L) {
            return new PAT4NodeShort(c1, c2, c3, c4, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new PAT4NodeInt(c1, c2, c3, c4, count);
        }
        return new PAT4NodeLong(c1, c2, c3, c4, count);
    }

    static Node createPATArrayNode(char[] cs, long count) {
        if (count == 1L) {
            return new PATArrayNodeOne(cs);
        }
        if (count == 2L) {
            return new PATArrayNodeTwo(cs);
        }
        if (count == 3L) {
            return new PATArrayNodeThree(cs);
        }
        if (count <= 127L) {
            return new PATArrayNodeByte(cs, count);
        }
        if (count <= 32767L) {
            return new PATArrayNodeShort(cs, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new PATArrayNodeInt(cs, count);
        }
        return new PATArrayNodeLong(cs, count);
    }

    static Node createPATNode(char firstC, char[] restCs, long count) {
        switch (restCs.length) {
            case 0: {
                return NodeFactory.createNode(firstC, count);
            }
            case 1: {
                return NodeFactory.createNode(firstC, restCs[0], count);
            }
            case 2: {
                return NodeFactory.createNode(firstC, restCs[0], restCs[1], count);
            }
            case 3: {
                return NodeFactory.createNode(firstC, restCs[0], restCs[1], restCs[2], count);
            }
        }
        char[] cs = new char[restCs.length + 1];
        cs[0] = firstC;
        System.arraycopy(restCs, 0, cs, 1, restCs.length);
        return NodeFactory.createPATArrayNode(cs, count);
    }

    static Node createNodeFold(char c, Node dtr, long count) {
        if (dtr.count() == count) {
            if (dtr instanceof AbstractPATNode) {
                AbstractPATNode patDtr = (AbstractPATNode)dtr;
                return NodeFactory.createPATNode(c, patDtr.chars(), count);
            }
            if (dtr instanceof TerminalNode) {
                return NodeFactory.createNode(c, count);
            }
        }
        return NodeFactory.createNode(c, dtr, count);
    }

    static Node createNode(char c, Node dtr, long count) {
        if (count <= 127L) {
            return new OneDtrNodeByte(c, dtr, count);
        }
        if (count <= 32767L) {
            return new OneDtrNodeShort(c, dtr, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new OneDtrNodeInt(c, dtr, count);
        }
        return new OneDtrNodeLong(c, dtr, count);
    }

    static Node createNode(char c1, Node dtr1, char c2, Node dtr2, long count) {
        if (count <= 127L) {
            return new TwoDtrNodeByte(c1, dtr1, c2, dtr2, count);
        }
        if (count <= 32767L) {
            return new TwoDtrNodeShort(c1, dtr1, c2, dtr2, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new TwoDtrNodeInt(c1, dtr1, c2, dtr2, count);
        }
        return new TwoDtrNodeLong(c1, dtr1, c2, dtr2, count);
    }

    static Node createNode(char c1, Node dtr1, char c2, Node dtr2, char c3, Node dtr3, long count) {
        if (count <= 127L) {
            return new ThreeDtrNodeByte(c1, dtr1, c2, dtr2, c3, dtr3, count);
        }
        if (count <= 32767L) {
            return new ThreeDtrNodeShort(c1, dtr1, c2, dtr2, c3, dtr3, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new ThreeDtrNodeInt(c1, dtr1, c2, dtr2, c3, dtr3, count);
        }
        return new ThreeDtrNodeLong(c1, dtr1, c2, dtr2, c3, dtr3, count);
    }

    static Node createArrayDtrNode(char[] cs, Node[] dtrs, long count) {
        if (count <= 127L) {
            return new ArrayDtrNodeByte(cs, dtrs, count);
        }
        if (count <= 32767L) {
            return new ArrayDtrNodeShort(cs, dtrs, count);
        }
        if (count <= Integer.MAX_VALUE) {
            return new ArrayDtrNodeInt(cs, dtrs, count);
        }
        return new ArrayDtrNodeLong(cs, dtrs, count);
    }

    static {
        for (int i = 0; i < TERMINAL_NODES.length; ++i) {
            NodeFactory.TERMINAL_NODES[i] = NodeFactory.createTerminalNode(i);
        }
        EMPTY_NODES = new Node[0];
    }
}

