[ROLE]
You are novice coder, and want to generate a user query exactly based on following guidelines. 
---
[INPUT]
You will be given `query`, `info`, and `maskinfo`. This `query` is a command for generating a python code function. The `info` consists of extracted information from the user query in JSON format. The `maskinfo` consists of masked information, where "MASK" is not a value but the masking token to represent that the information for that key has been removed.
---
[TASK]
You need to generate `mask query` with all information from the `maskinfo` ONLY. For completing the task follow these METHOD step-by-step:-
[METHOD]
1. Understand how connection of `info` is set with the `query`. Learn the technique of how to phrase using the extracted `info` into a natural language human like `query`.
2. Translate this knowledge and generate `mask query` just by using `maskinfo`. While doing this keep the following in mind:-
- `mask query` should NOT contain any information or phrase pertaining to MASKed key value
- `mask query` should NOT be exactly same as `query`
- DO NOT add any new information apart from `mask query` in `maskinfo`
- DO NOT alter/phrase/omit information that has NOT been MASKed in `maskinfo`
- ALWAYS make sure for the information in `maskinfo` that has NOT been MASKed, you need to use the same phrasing as in `query` for the `mask query` for information that is same as in `info`
- `mask keys`: List the key that are MASKed in `maskinfo`
- OMIT mentioning/do not specify, the MASKed key phrase in `mask query`.

---

`query`: Write a python function to return product number in words all in lowercase, of an integer with first k items of two given lists. If any list is empty, return '-'.
`info`: {"task": "product", "method": [], "input_type": ["integer","list"], "input_property": ["first k", "two"], "output_type": ["in words"], "output_property": ["lowercase"], "edge_cases": {"any empty": "'-'"}}
`maskinfo`: {"task": "product", "method": [], "input_type": ["integer","MASK"], "input_property": ["first k", "two"], "output_type": ["in words"], "output_property": ["lowercase"], "edge_cases": {"any empty": "MASK"}}
`mask query`: Write a python function to return product of an integer with first k items of two.
---

`query`: Write a function to sort in ascending order on top k items of list.
`info`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["top k"], "output_type": [], "output_property": ["ascending"], "edge_cases": {}}
`maskinfo`: {"task": "sort", "method": [], "input_type": ["list"], "input_property": ["top k"], "output_type": [], "output_property": ["MASK"], "edge_cases": {}}
`mask query`: Write a function to sort on top k items of list.
---

`query`: {{originalNL}}
`info`: {{info}}
`maskinfo`: {{maskinfo}}
`mask query`: 