print_cmd()
{
    source $1
    echo "PROFILE: $1"
    echo "------------------------------------------------- runing cmd -------------------------------------------------"
    echo "torchrun $DISTRIBUTED_ARGS finetune.py 
                --model_name_or_path $MODEL 
                --data_path ${DATA[@]} 
                --eval_data_path ${DATA_EVAL[@]} 
                --fp16 True 
                --output_dir $OUTPUT_PATH 
                --eval_output_dir $OUTPUT_PATH 
                --num_train_epochs 10 
                --per_device_train_batch_size 8 
                --per_device_eval_batch_size 16 
                --gradient_accumulation_steps 2 
                --evaluation_strategy "epoch" 
                --save_strategy "epoch" 
                --save_total_limit 10 
                --learning_rate 2e-5 
                --weight_decay 0.1 
                --adam_beta2 0.95 
                --warmup_ratio 0.01 
                --lr_scheduler_type "cosine" 
                --logging_steps 1 
                --report_to "none" 
                --model_max_length 512 
                --gradient_checkpointing True 
                --lazy_preprocess True 
                --deepspeed finetune/ds_config_zero3.json 
                --classfication True 
                --use_prompt False 
                --only_prompt False 
                --fix_prompt False 
                --fix_word_embeddings True " 
    echo "--------------------------------------------------------------------------------------------------------------"
    echo ""
}

###
# TODO: imdb finetuning 只跑了一轮 目前 COPA -4 imdb -0.1 paws -0.01
###

# tasks=("boolq" "cb" "copa" "mrc" "rte" "wic" "snli" "paws" "imdb" "anlir1" "anlir2" "winogrande" "scitail" "anlir3")
# for task in ${tasks[@]}
# do 
#     export PROFILE="finetune/configs/finetuning_bikt_32shot/${task}_config.sh"
#     print_cmd $PROFILE
#     bash finetune/finetune_ds_phi.sh 

#     export PROFILE="finetune/configs/finetuning_32shot/${task}_config.sh"
#     print_cmd $PROFILE
#     bash finetune/finetune_ds_phi.sh 
# done

tasks=("anlir1" "anlir2" "winogrande" "scitail" "anlir3")
for task in ${tasks[@]}
do 
    export PROFILE="finetune/configs/finetuning_bikt_100shot/${task}_config.sh"
    print_cmd $PROFILE
    bash finetune/finetune_ds_phi.sh 

    export PROFILE="finetune/configs/finetuning_100shot/${task}_config.sh"
    print_cmd $PROFILE
    bash finetune/finetune_ds_phi.sh 
done