import os
from openai import OpenAI

class Prompter:
    def __init__(self):
        self.client = OpenAI(
            api_key = os.environ.get("OPENAI_API_KEY"),
        )

    def _run_prompt(self, messages, temp=0):
        response = self.client.chat.completions.create(
            messages = messages,
            model="gpt-4-turbo",
            temperature=temp,
            max_tokens=1024,
        )
        return response

    def prompt(self, mention_list, entity):
        initial_content = f"You are a helpful assistant."
        
        prompt = [{"role": "system", "content": initial_content}]

        str_list = repr(mention_list)

        content = (
            f"Provided List: {mention_list}\n\n"
            f"The provided list is a compilation of mentions identified in the textual corpora. Upon human verification, these mentions refer to {entity} in the text.\n"
            f"Select the mentions from the list that unambiguously refer to {entity} without context.\n"
            f"Unambiguous mentions are mentions that exclusively refer to the specified entity ({entity}) without requiring additional context.\n"
            f"Examples:\n"
            f" Unambiguous Mentions for Manchester_United_F.C.: \"Man Utd\", \"20-time English champions\", \"the Red Devils club\", ...\n"
            f" Ambiguous Mentions for Manchester_United_F.C.: \"United\", \"chaos club\", \"English Powerhouse\", \"the First Team\", ...\n\n"
            f"Instrutions:\n"
            f" 1. Write mentions exactly as they appear in the provided list. Do not modify the mentions in the list, even if they contain typos. Maintain the original capitalization and spacing.\n"
            f" 2. Be sure to follow the following format and write your answer within the list:\n"
            f"    [\"Mention 1\", \"Mention 2\", ... ]\n\n"
        )
        print(content)
        prompt.extend([{"role": "user", "content": content}])

        response = self._run_prompt(prompt)        
        res = response.choices[0].message.content
        return res
    
if __name__ == "__main__":

    mention = 'darwizzy'
    entity = 'Darwin_Núñez'
    
    prompter = Prompter()
    answer = prompter.prompt(mention, entity)

    # if 'no' in answer.lower():
    #     print(False)
    # else:
    #     print(True)