theory question_30_2
imports Main

begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Human :: "entity ⇒ bool"
  Tricks :: "event ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  Instrument :: "entity ⇒ bool"
  Doing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  HasProperty :: "entity ⇒ entity ⇒ bool"

(* Explanation: A man is doing tricks on a skateboard means a human is doing tricks. *)
axiomatization where
  explanation_1: "∀x y e. Man x ∧ Skateboard y ∧ Doing e ∧ Agent e x ∧ Patient e (Skateboard y) ∧ HasProperty y (Instrument Skateboard) ⟶ (∃x' e'. Human x' ∧ Doing e' ∧ Agent e' x' ∧ Tricks e')"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ Doing e ∧ Agent e x ∧ Patient e  Skateboard y  ∧ HasProperty y  Instrument Skateboard "
  (* Hypothesis: A human is doing tricks. *)
  shows "∃x' e'. Human x' ∧ Doing e' ∧ Agent e' x' ∧ Tricks e'"
proof -
  from asm have "Man x ∧ Skateboard y ∧ Doing e ∧ Agent e x ∧ Patient e (Skateboard y) ∧ HasProperty y (Instrument Skateboard)" by blast
  then have "Human x' ∧ Doing e' ∧ Agent e' x' ∧ Tricks e'"
    using explanation_1 by blast
  then show ?thesis by blast
qed

end
