theory question_72_3
imports Main

begin

typedecl entity
typedecl event

consts
  Riding :: "entity ⇒ bool"
  Something :: "entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  Involves :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Moving :: "event ⇒ bool"
  Over :: "event ⇒ entity ⇒ bool"
  Touching :: "event ⇒ entity ⇒ entity ⇒ bool"
  MovedAgainst :: "event ⇒ bool"
  MovedOver :: "event ⇒ bool"
  MovedDown :: "event ⇒ bool"
  Friction :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Causing :: "event ⇒ bool"
  Speed :: "event ⇒ bool"
  Decrease :: "event ⇒ bool"
  Surfaces :: "entity ⇒ bool"
  Wagon :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Hill :: "entity ⇒ bool"
  Stop :: "event ⇒ bool"
  Eventually :: "event ⇒ bool"

(* Explanation 1: Riding something involves moving that thing over a surface and having the surfaces touch. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Riding x ∧ Something y ∧ Surface z ∧ Involves e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (∃e2. Moving e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Over e2 z ∧ [Touching e2 y z])"

(* Explanation 2: If one surface is moved against, moved over, or moved down another surface, then those surfaces are touching. *)
axiomatization where
  explanation_2: "∀x y e1 e2 e3. Surface x ∧ Surface y ∧ (MovedAgainst e1 ∨ MovedOver e2 ∨ MovedDown e3) ∧ Agent e1 x ∧ Patient e1 y ∧ Agent e2 x ∧ Patient e2 y ∧ Agent e3 x ∧ Patient e3 y ⟶ [Touching x y]"

(* Explanation 3: Friction causes the speed of an object to decrease when the surfaces are touching. *)
axiomatization where
  explanation_3: "∀x y e1 e2. Friction x ∧ Object y ∧ Causing e1 ∧ Agent e1 x ∧ Patient e1 e2 ∧ Speed e2 ∧ Decrease e2 ∧ Agent e2 y ∧ Surfaces z ∧ [Touching z] ⟶ Patient e2 y"

(* Explanation 4: A wagon is a kind of vehicle. *)
axiomatization where
  explanation_4: "∀x. Wagon x ⟶ Vehicle x"

(* Explanation 5: A hill is a kind of surface. *)
axiomatization where
  explanation_5: "∀x. Hill x ⟶ Surface x"

theorem hypothesis:
  (* Premise: a child rides a wagon down a hill. *)
  assumes asm: "Child x ∧ Wagon y ∧ Hill z ∧ Riding e ∧ Agent e x ∧ Patient e y ∧ Down e ∧ Patient e z"
  (* Premise: eventually, the wagon comes to a stop. *)
  assumes asm2: "Wagon x ∧ Stop e ∧ Agent e x ∧ Eventually e"
  (* Hypothesis: Friction acting on the wagon is responsible for causing the wagon to stop. *)
  shows "∃x y e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧  Causing e2 ∧ Agent e2 x ∧ Patient e2 e1 ∧ Stop e1 ∧ Agent e1 y "
proof -
  {
    assume asm: "Child x ∧ Wagon y ∧ Hill z ∧ Riding e ∧ Agent e x ∧ Patient e y ∧ Down e ∧ Patient e z"
    assume asm2: "Wagon y ∧ Stop e' ∧ Agent e' y ∧ Eventually e'"
    from asm have "Riding x" by simp
    from asm have "Wagon y" by simp
    from asm have "Hill z" by simp
    from asm have "Down e" by simp
    from asm have "Agent e x" by simp
    from asm have "Patient e y" by simp
    from asm have "Patient e z" by simp
    from explanation_1[OF asm] obtain e1 where e1: "Moving e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Over e1 z ∧ Touching e1 y z" by blast
    from explanation_2[OF asm, OF e1] have "Touching z y" by blast
    from explanation_3[OF asm, OF e1, OF asm2] obtain e2 where e2: "Friction x ∧ Acting e2 ∧ Agent e2 x ∧ Patient e2 y ∧ Causing e' ∧ Agent e' x ∧ Patient e' e2 ∧ Stop e2 ∧ Agent e2 y" by blast
    from e2 have "Friction x" by simp
    from e2 have "Wagon y" by simp
    from e2 have "Acting e2" by simp
    from e2 have "Agent e2 x" by simp
    from e2 have "Patient e2 y" by simp
    from e2 have "Causing e'" by simp
    from e2 have "Agent e' x" by simp
    from e2 have "Patient e' e2" by simp
    from e2 have "Stop e2" by simp
    from e2 have "Agent e2 y" by simp
    with asm2 have "Stop e2 ∧ Agent e2 y" by simp
    then show ?thesis using asm e2 by blast
  }
qed

end
