theory question_17_2

imports Main

begin
typedecl entity
typedecl event

consts
  FootballPlayer :: "entity ⇒ bool"
  Jerseys :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Color :: "entity ⇒ entity"
  Orange :: entity
  White :: entity
  StartingLine :: "entity ⇒ bool"
  Set :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: If an entity is a football player, then the entity is capable of wearing a jersey. *)
axiomatization where
  explanation_1: "∀x. FootballPlayer x ⟶ (∃j. Jerseys j ∧ Wearing x j)"

(* Explanation 2: Two entities are different football players wearing different colored jerseys. *)
axiomatization where
  explanation_2: "∃x y j1 j2. FootballPlayer x ∧ FootballPlayer y ∧ Jerseys j1 ∧ Jerseys j2 ∧ Wearing x j1 ∧ Wearing y j2 ∧ x ≠ y ∧ j1 ≠ j2 ∧ Color j1 ≠ Color j2"

(* Explanation 3: If two entities are different football players wearing different colored jerseys, then both entities are wearing jerseys. *)
axiomatization where
  explanation_3: "∀x y j1 j2. FootballPlayer x ∧ FootballPlayer y ∧ Jerseys j1 ∧ Jerseys j2 ∧ Wearing x j1 ∧ Wearing y j2 ∧ x ≠ y ∧ j1 ≠ j2 ∧ Color j1 ≠ Color j2 ⟶ Wearing x j1 ∧ Wearing y j2"

theorem hypothesis:
  (* Premise: One football player wearing an orange jersey and one wearing a white jersey are set at the starting line. *)
  assumes asm: "FootballPlayer x ∧ FootballPlayer y ∧ Jerseys j1 ∧ Jerseys j2 ∧ Wearing x j1 ∧ Wearing y j2 ∧ Color j1 = Orange ∧ Color j2 = White ∧ x ≠ y ∧ j1 ≠ j2 ∧ StartingLine l ∧ Set x l ∧ Set y l"
  (* Hypothesis: Two football players wearing jerseys. *)
  shows "∃x y. FootballPlayer x ∧ FootballPlayer y ∧ Jerseys x ∧ Jerseys y ∧ x ≠ y"
proof -
  from asm have "FootballPlayer x" and "FootballPlayer y" and "x ≠ y" by blast+
  then have "Jerseys j1" and "Jerseys j2" and "Wearing x j1" and "Wearing y j2" using explanation_3 by blast+
  then show ?thesis using asm `x` `y` by blast
qed

end
